/*
 * Decompiled with CFR 0.152.
 */
package debugger.gui.debugging;

import debugger.gui.debugging.SyntaxDocument;
import debugger.resources.ResourcesFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.StyledEditorKit;

public class JapeSourcePanel
extends JComponent {
    private JEditorPane editorPane;
    private JButton saveButton;
    private JButton reinitButton;
    private String saveButtonString = "Save";
    private String reinitButtonString = "Reinitialize";

    public JapeSourcePanel() {
        this.initGui();
        this.editorPane.setEditorKit(new StyledEditorKit());
        this.editorPane.setDocument(new SyntaxDocument());
        this.upgradeTextPane();
        this.initListeners();
    }

    private void initGui() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.editorPane = new JTextPane();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 3, 3, 4);
        this.editorPane.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)new JScrollPane(this.editorPane), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)new JPanel(), gridBagConstraints);
        this.saveButton = new JButton(this.saveButtonString);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        this.add((Component)this.saveButton, gridBagConstraints);
        this.reinitButton = new JButton(this.reinitButtonString);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.saveButton.setPreferredSize(this.getButtonSize());
        this.saveButton.setMinimumSize(this.getButtonSize());
        this.saveButton.setMaximumSize(this.getButtonSize());
        this.reinitButton.setPreferredSize(this.getButtonSize());
        this.reinitButton.setMinimumSize(this.getButtonSize());
        this.reinitButton.setMaximumSize(this.getButtonSize());
        this.add((Component)this.reinitButton, gridBagConstraints);
    }

    public void upgradeTextPane() {
        if (ResourcesFactory.getCurrentJapeFile() == null) {
            return;
        }
        if (!this.editorPane.getText().equals(ResourcesFactory.getCurrentJapeText())) {
            this.editorPane.setText(ResourcesFactory.getCurrentJapeText());
        }
        try {
            int n = this.editorPane.getText().indexOf(ResourcesFactory.getCurrentRuleModel().getName());
            this.editorPane.setCaretPosition(n);
            this.editorPane.grabFocus();
            Rectangle rectangle = this.editorPane.modelToView(n);
            Rectangle rectangle2 = this.editorPane.getVisibleRect();
            this.editorPane.scrollRectToVisible(new Rectangle(0, rectangle.y + rectangle2.height, 1, 1));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (ResourcesFactory.getCurrentJapeFile().canWrite()) {
            this.saveButton.setEnabled(true);
            this.editorPane.setEditable(true);
        } else {
            this.saveButton.setEnabled(false);
            this.editorPane.setEditable(false);
        }
    }

    private Dimension getButtonSize() {
        int n = this.saveButton.getFontMetrics(this.saveButton.getFont()).stringWidth(this.saveButtonString);
        int n2 = this.reinitButton.getFontMetrics(this.reinitButton.getFont()).stringWidth(this.reinitButtonString) + 25;
        return new Dimension(Math.max(n, n2) + 21, 25);
    }

    private void initListeners() {
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.reinitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
    }
}

