/*
 * Decompiled with CFR 0.152.
 */
package debugger.gui.debugging;

import debugger.gui.GuiFactory;
import debugger.gui.debugging.SyntaxDocument;
import debugger.gui.debugging.debugviews.PrimaryTextPanel;
import debugger.resources.ResourcesFactory;
import debugger.resources.pr.PhaseModel;
import debugger.resources.pr.RuleModel;
import debugger.resources.pr.RuleTrace;
import debugger.resources.pr.TraceContainer;
import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.text.DefaultCaret;
import javax.swing.text.StyledEditorKit;

public class JapeDebuggingPanel
extends JPanel {
    private JPanel rulePanel;
    private JLabel phaseName;
    private JLabel ruleName;
    private JTextPane selectedTextPane;
    private JTextPane rulePane;
    private JButton nextAnnotationButton;
    private JButton previousAnnotationButton;
    private PhaseModel currentPhaseModel;
    private RuleModel currentRuleModel;
    private TraceContainer traceContainer;
    private Document document;
    private int currentStartOffset;
    private int currentEndOffset;
    private TraceContainer currentTraces;
    private RuleTrace currentRuleTrace;
    private AnnotationSet currentAnnotationCut;

    public JapeDebuggingPanel() {
        this.initGui();
    }

    private void initGui() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.getUpperPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.getRulePane(), 20, 30);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Rule Text"));
        JScrollPane jScrollPane2 = new JScrollPane(this.getRulePanel(), 20, 30);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Rule"));
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane2, jScrollPane);
        jSplitPane.setDividerLocation(200);
        this.add((Component)jSplitPane, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
    }

    private JTextPane getRulePane() {
        if (this.rulePane == null) {
            this.rulePane = new JTextPane();
            this.rulePane.setEditorKit(new StyledEditorKit());
            this.rulePane.setDocument(new SyntaxDocument());
            this.rulePane.setEditable(false);
            this.rulePane.setCaret(new DefaultCaret(){

                protected void adjustVisibility(Rectangle rectangle) {
                }
            });
        }
        return this.rulePane;
    }

    private JComponent getSelectedTextPane() {
        this.selectedTextPane = new JTextPane();
        this.selectedTextPane.setEditable(false);
        this.selectedTextPane.setCaret(new DefaultCaret(){

            protected void adjustVisibility(Rectangle rectangle) {
            }
        });
        this.nextAnnotationButton = new JButton("Next");
        this.previousAnnotationButton = new JButton("Previous");
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.previousAnnotationButton, gridBagConstraints);
        this.previousAnnotationButton.setEnabled(false);
        this.previousAnnotationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JapeDebuggingPanel.this.currentTraces != null && JapeDebuggingPanel.this.currentRuleModel != null && JapeDebuggingPanel.this.currentRuleTrace != null) {
                    int n = JapeDebuggingPanel.this.currentTraces.lastIndexOf(JapeDebuggingPanel.this.currentRuleTrace);
                    if (n > 0) {
                        JapeDebuggingPanel.this.updateRulePanel(JapeDebuggingPanel.this.currentRuleModel, (RuleTrace)JapeDebuggingPanel.this.currentTraces.get(n - 1));
                        JapeDebuggingPanel.this.currentRuleTrace = (RuleTrace)JapeDebuggingPanel.this.currentTraces.get(n - 1);
                    }
                    if (n - 1 == 0) {
                        JapeDebuggingPanel.this.previousAnnotationButton.setEnabled(false);
                    } else {
                        JapeDebuggingPanel.this.previousAnnotationButton.setEnabled(true);
                    }
                    if (n < JapeDebuggingPanel.this.currentTraces.size() && JapeDebuggingPanel.this.currentTraces.size() > 1) {
                        JapeDebuggingPanel.this.nextAnnotationButton.setEnabled(true);
                    }
                }
                GuiFactory.getResourceView().repaint();
            }
        });
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.nextAnnotationButton, gridBagConstraints);
        this.nextAnnotationButton.setEnabled(false);
        this.nextAnnotationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JapeDebuggingPanel.this.currentTraces != null && JapeDebuggingPanel.this.currentRuleModel != null && JapeDebuggingPanel.this.currentRuleTrace != null) {
                    int n = JapeDebuggingPanel.this.currentTraces.lastIndexOf(JapeDebuggingPanel.this.currentRuleTrace);
                    if (n + 1 < JapeDebuggingPanel.this.currentTraces.size()) {
                        JapeDebuggingPanel.this.updateRulePanel(JapeDebuggingPanel.this.currentRuleModel, (RuleTrace)JapeDebuggingPanel.this.currentTraces.get(n + 1));
                        JapeDebuggingPanel.this.currentRuleTrace = (RuleTrace)JapeDebuggingPanel.this.currentTraces.get(n + 1);
                    }
                    if (n + 2 >= JapeDebuggingPanel.this.currentTraces.size()) {
                        JapeDebuggingPanel.this.nextAnnotationButton.setEnabled(false);
                    } else {
                        JapeDebuggingPanel.this.nextAnnotationButton.setEnabled(true);
                    }
                    if (n + 1 > 0) {
                        JapeDebuggingPanel.this.previousAnnotationButton.setEnabled(true);
                    }
                    GuiFactory.getResourceView().repaint();
                }
            }
        });
        return jPanel;
    }

    private JComponent getRulePanel() {
        if (this.rulePanel == null) {
            this.rulePanel = new JPanel();
        }
        return this.rulePanel;
    }

    private JComponent getUpperPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel.add((Component)new JLabel("Rule: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.ruleName = new JLabel();
        jPanel.add((Component)this.ruleName, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)new JLabel("Phase: "), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        this.phaseName = new JLabel();
        jPanel.add((Component)this.phaseName, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        jPanel.add((Component)this.getSelectedTextPane(), gridBagConstraints);
        return jPanel;
    }

    public void setText(int n, int n2, Document document) {
        TraceContainer traceContainer = ResourcesFactory.getPhaseController().getRuleTrace();
        traceContainer = traceContainer.getTraceByOffset(new Long(n), new Long(n2));
        try {
            this.selectedTextPane.setText(document.getContent().getContent(new Long(n), new Long(n2)).toString());
        }
        catch (InvalidOffsetException invalidOffsetException) {
            invalidOffsetException.printStackTrace();
        }
        this.traceContainer = traceContainer;
        this.document = document;
        this.currentStartOffset = n;
        this.currentEndOffset = n2;
        this.updateRulePanel(null, null);
        this.repaint();
    }

    private JComponent createAnnotationPanel(AnnotationSet annotationSet, String string, RuleTrace ruleTrace, boolean bl) {
        Serializable serializable;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        AnnotationSet annotationSet2 = null;
        if (ruleTrace != null) {
            annotationSet2 = ruleTrace.getAnnotations();
        }
        long l = 0L;
        if (annotationSet2 != null) {
            l = annotationSet2.lastNode().getOffset();
        }
        HashSet<Serializable> hashSet = new HashSet<Serializable>();
        if (annotationSet != null) {
            hashSet.addAll(annotationSet);
        }
        HashSet<Annotation> hashSet2 = new HashSet<Annotation>();
        for (Annotation serializable22 : hashSet) {
            serializable = this.currentAnnotationCut.getContained(serializable22.getStartNode().getOffset(), serializable22.getEndNode().getOffset()).get("Token");
            if (serializable == null) continue;
            hashSet2.addAll((Collection<Annotation>)((Object)serializable));
        }
        AnnotationSet annotationSet3 = this.currentAnnotationCut.get("Token", new Long(this.currentStartOffset), new Long(this.currentEndOffset));
        if (annotationSet3 != null) {
            Iterator<Annotation> iterator = annotationSet3.iterator();
            while (iterator.hasNext()) {
                serializable = iterator.next();
                if (hashSet2.contains(serializable)) continue;
                hashSet.add(serializable);
            }
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList, new OffsetComparator());
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                Annotation annotation = (Annotation)object;
                Annotation annotation2 = (Annotation)object2;
                long l = annotation.getStartNode().getOffset();
                long l2 = annotation2.getStartNode().getOffset();
                long l3 = annotation.getEndNode().getOffset() - l;
                long l4 = annotation2.getEndNode().getOffset() - l2;
                if (l > l2) {
                    return 1;
                }
                if (l < l2) {
                    return -1;
                }
                if (l == l2) {
                    if (l3 > l4) {
                        return -1;
                    }
                    if (l3 < l4) {
                        return 1;
                    }
                    return 0;
                }
                return 0;
            }
        });
        serializable = new ArrayList();
        boolean bl2 = false;
        int n = 0;
        for (Annotation annotation : arrayList) {
            Serializable serializable22;
            AnnotationSet annotationSet4 = this.currentAnnotationCut.getContained(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).get(string);
            if (annotationSet4 != null) {
                for (Serializable serializable22 : annotationSet4) {
                    if (serializable22.equals(annotation)) continue;
                    ((ArrayList)serializable).add(serializable22);
                }
            }
            AnnotationSet annotationSet5 = this.currentAnnotationCut.getContained(annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).get("Token");
            serializable22 = null;
            serializable22 = annotationSet5 != null ? new ArrayList(annotationSet5) : new ArrayList();
            Collections.sort(serializable22, new OffsetComparator());
            int n2 = 0;
            if (((ArrayList)serializable).contains(annotation)) continue;
            Iterator iterator = ((ArrayList)serializable22).iterator();
            while (iterator.hasNext()) {
                Object object3;
                Object object2;
                Annotation annotation2 = (Annotation)iterator.next();
                String string2 = (String)annotation2.getFeatures().get("string");
                PrimaryTextPanel primaryTextPanel = new PrimaryTextPanel(string2, false, 0);
                if (annotationSet4 != null) {
                    primaryTextPanel.setAnnotations(new ArrayList<Annotation>(annotationSet4));
                } else {
                    object2 = new ArrayList<Annotation>();
                    ((ArrayList)object2).add(annotation);
                    primaryTextPanel.setAnnotations((ArrayList)object2);
                }
                if (annotationSet5.size() == 1) {
                    primaryTextPanel.setOpenMode(0);
                } else if (n2 == 0 && annotationSet5.size() > 1) {
                    primaryTextPanel.setOpenMode(2);
                } else if (n2 == annotationSet5.size() - 1) {
                    primaryTextPanel.setOpenMode(1);
                } else {
                    primaryTextPanel.setOpenMode(3);
                }
                if (annotation2.equals(annotation) && !string.equals("Token")) {
                    primaryTextPanel.setTextVisible(false);
                }
                if (annotationSet2 != null && annotationSet2.contains(annotation) && primaryTextPanel.isTextVisible() && bl) {
                    primaryTextPanel.setHighlighted(true);
                }
                if (annotationSet4 != null) {
                    for (Object object3 : annotationSet4) {
                        if (annotationSet2 == null || !annotationSet2.contains(object3) || !primaryTextPanel.isTextVisible()) continue;
                        int n3 = object3.getStartNode().getOffset().intValue();
                        int n4 = object3.getEndNode().getOffset().intValue();
                        int n5 = annotation2.getStartNode().getOffset().intValue();
                        int n6 = annotation2.getEndNode().getOffset().intValue();
                        if (n3 > n5 || n6 > n4 || n4 < n5 || !bl) continue;
                        primaryTextPanel.setHighlighted(true);
                    }
                }
                if (ruleTrace != null && !ruleTrace.isFinished() && annotation.getStartNode().getOffset() >= l && !bl2 && primaryTextPanel.isTextVisible() && bl) {
                    primaryTextPanel.setRed(true);
                    if (primaryTextPanel.getOpenMode() == 0 || primaryTextPanel.getOpenMode() == 1) {
                        bl2 = true;
                    }
                }
                object2 = "";
                object3 = null;
                if (ruleTrace != null) {
                    object3 = ruleTrace.getPattern(annotation);
                }
                if (object3 == null && annotationSet4 != null && ruleTrace != null) {
                    Iterator<Annotation> iterator2 = annotationSet4.iterator();
                    while (iterator2.hasNext() && (object3 = ruleTrace.getPattern(iterator2.next())) == null) {
                    }
                }
                if (object3 != null) {
                    Iterator iterator3 = object3.keySet().iterator();
                    while (iterator3.hasNext()) {
                        object2 = (String)object2 + " " + string + ".";
                        Object k = iterator3.next();
                        object2 = (String)object2 + k + "=" + object3.get(k);
                    }
                    if (object3.keySet().isEmpty()) {
                        object2 = string;
                    }
                }
                if (object3 != null && primaryTextPanel.isTextVisible() && (primaryTextPanel.isHighlighted() || primaryTextPanel.isRed()) && bl) {
                    primaryTextPanel.setToolTipText((String)object2);
                }
                gridBagConstraints.gridx = n++;
                jPanel.add((Component)primaryTextPanel, gridBagConstraints);
                ++n2;
            }
        }
        return jPanel;
    }

    public void updateRulePanel(RuleModel ruleModel, RuleTrace ruleTrace) {
        Serializable serializable;
        if (ruleModel != null) {
            this.rulePane.setText(ruleModel.getRuleText());
        }
        RuleTrace ruleTrace2 = null;
        if (ruleTrace == null && this.traceContainer != null) {
            if (this.traceContainer != null) {
                serializable = this.traceContainer.getTraceByRuleModel(ruleModel);
                if (((ArrayList)serializable).size() > 0) {
                    ruleTrace2 = (RuleTrace)((ArrayList)serializable).iterator().next();
                }
                this.previousAnnotationButton.setEnabled(false);
                this.nextAnnotationButton.setEnabled(false);
                if (((ArrayList)serializable).size() > 1) {
                    this.nextAnnotationButton.setEnabled(true);
                }
                this.currentTraces = serializable;
                this.currentRuleTrace = ruleTrace2;
            }
        } else {
            this.currentRuleTrace = ruleTrace2 = ruleTrace;
        }
        if (this.traceContainer != null) {
            this.currentAnnotationCut = this.traceContainer.getPhaseCut(this.currentPhaseModel);
            serializable = new JPanel();
            ((Container)serializable).setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 4, 2, 4);
            if (this.currentPhaseModel != null) {
                for (String string : this.currentPhaseModel.getInput()) {
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.gridy = n++;
                    ((Container)serializable).add(new JLabel(string), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    if (this.currentAnnotationCut != null) {
                        ((Container)serializable).add(this.createAnnotationPanel(this.currentAnnotationCut.get(string, new Long(this.currentStartOffset), new Long(this.currentEndOffset)), string, ruleTrace2, true), gridBagConstraints);
                    } else {
                        ((Container)serializable).add(new JLabel("No annotations of type " + string + " available"), gridBagConstraints);
                    }
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    ((Container)serializable).add(new JPanel(), gridBagConstraints);
                }
            }
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 2;
            ((Container)serializable).add(new JPanel(){
                {
                    this.setBackground(Color.black);
                }

                public Dimension getPreferredSize() {
                    return this.getMaximumSize();
                }

                public Dimension getMaximumSize() {
                    return new Dimension(20, 2);
                }
            }, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = n++;
            ((Container)serializable).add(new JPanel(), gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridy = n++;
            ((Container)serializable).add(new JLabel(""), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            if (this.document.getAnnotations().getContained(new Long(this.currentStartOffset), new Long(this.currentEndOffset)).get("Token") != null) {
                if (this.currentAnnotationCut == null) {
                    this.currentAnnotationCut = this.document.getAnnotations().getContained(new Long(this.currentStartOffset), new Long(this.currentEndOffset)).get("Token");
                }
                ((Container)serializable).add(this.createAnnotationPanel(this.document.getAnnotations().getContained(new Long(this.currentStartOffset), new Long(this.currentEndOffset)).get("Token"), "Token", ruleTrace2, false), gridBagConstraints);
            } else {
                ((Container)serializable).add(new JLabel("No annotations of type Token available"), gridBagConstraints);
            }
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            ((Container)serializable).add(new JPanel(), gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            ((Container)serializable).add(new JPanel(), gridBagConstraints);
            this.getRulePanel().removeAll();
            this.getRulePanel().setLayout(new BorderLayout());
            this.getRulePanel().add((Component)serializable, "Center");
            this.revalidate();
        }
    }

    public void setCurrentRule(RuleModel ruleModel) {
        this.currentRuleModel = ruleModel;
        this.currentPhaseModel = ruleModel.getParentPhase();
        this.phaseName.setText(this.currentPhaseModel.getName() + "   Control = " + this.currentPhaseModel.getControl());
        this.ruleName.setText(ruleModel.getName());
    }

    public void setCurrentPhase(PhaseModel phaseModel) {
        this.currentPhaseModel = phaseModel;
        this.phaseName.setText(this.currentPhaseModel.getName() + "   Control = " + this.currentPhaseModel.getControl());
        if (this.currentRuleModel != null && !this.currentRuleModel.getParentPhase().equals(this.currentPhaseModel)) {
            this.getRulePanel().removeAll();
            this.getRulePanel().add(new JLabel("No rule currently selected."));
        }
        this.ruleName.setText("");
    }

    public RuleTrace getCurrentRuleTrace() {
        return this.currentRuleTrace;
    }

    public RuleModel getCurrentRuleModel() {
        return this.currentRuleModel;
    }
}

