/*
 * Decompiled with CFR 0.152.
 */
package debugger.gui.actions.resources;

import debugger.gui.GuiFactory;
import debugger.resources.ResourcesFactory;
import debugger.resources.pr.RuleModel;
import gate.AnnotationSet;
import java.awt.Color;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public class RuleSelectedAction
implements Runnable {
    private static RuleSelectedAction ourInstance;
    private RuleModel ruleModel;

    public static synchronized RuleSelectedAction getInstance() {
        if (ourInstance == null) {
            ourInstance = new RuleSelectedAction();
        }
        return ourInstance;
    }

    private RuleSelectedAction() {
    }

    public void actionPerformed(RuleModel ruleModel) {
        this.ruleModel = ruleModel;
        SwingUtilities.invokeLater(this);
    }

    private int getSlashNAmount(int n, AnnotationSet annotationSet) {
        try {
            String string = annotationSet.getDocument().getContent().getContent(new Long(0L), new Long(n)).toString();
            if (string.equals("")) {
                return 0;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            if (string.endsWith("\n")) {
                return stringTokenizer.countTokens();
            }
            return stringTokenizer.countTokens() - 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public void run() {
        ResourcesFactory.setCurrentRuleModel(this.ruleModel);
        int n = 0;
        int n2 = 0;
        for (String string : this.ruleModel.getBindings().keySet()) {
            if (!string.startsWith("(")) continue;
            AnnotationSet annotationSet = (AnnotationSet)this.ruleModel.getBindings().get(string);
            if (annotationSet != null) {
                try {
                    n = ((AnnotationSet)this.ruleModel.getBindings().get(string)).firstNode().getOffset().intValue();
                    n2 = ((AnnotationSet)this.ruleModel.getBindings().get(string)).lastNode().getOffset().intValue();
                    GuiFactory.getDocumentEditor().setTextSelection(Color.cyan, n, n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            GuiFactory.getDocumentEditor().setTextSelection(Color.cyan, 0, 0);
        }
        GuiFactory.getDebugPanel().getRulePanel().ruleSelected();
        GuiFactory.getDebugPanel().getJapeSourcePanel().upgradeTextPane();
        GuiFactory.getDebugPanel().getTraceHistoryPanel().updateRulePanel(this.ruleModel, null);
    }
}

