/*
 * Decompiled with CFR 0.152.
 */
package debugger.gui.actions.resources;

import debugger.gui.GuiFactory;
import debugger.resources.ResourcesFactory;
import debugger.resources.lr.LrModel;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;

public class LrResourceSelectedAction
implements Runnable {
    private static LrResourceSelectedAction ourInstance;
    private LrModel lrModel;

    public static synchronized LrResourceSelectedAction getInstance() {
        if (ourInstance == null) {
            ourInstance = new LrResourceSelectedAction();
        }
        return ourInstance;
    }

    private LrResourceSelectedAction() {
    }

    public void actionPerformed(LrModel lrModel) {
        this.lrModel = lrModel;
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        ResourcesFactory.setCurrentLrModel(this.lrModel);
        GuiFactory.getDocumentEditor().getTextPane().setText(this.lrModel == null ? "" : this.lrModel.getText());
        GuiFactory.getDocumentEditor().setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.lrModel == null ? "No document selected" : this.lrModel.getName()));
        GuiFactory.getDocumentEditor().revalidate();
    }
}

