/*
 * Decompiled with CFR 0.152.
 */
package debugger.gui.actions.editor;

import debugger.gui.GuiFactory;
import debugger.resources.JapeFile;
import debugger.resources.ResourcesFactory;
import debugger.resources.pr.RuleModel;
import gate.AnnotationSet;
import gate.jape.SinglePhaseTransducer;
import gate.util.Files;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;

public class ShowRuleInfoAction {
    private static ShowRuleInfoAction ourInstance;

    public static synchronized ShowRuleInfoAction getInstance() {
        if (ourInstance == null) {
            ourInstance = new ShowRuleInfoAction();
        }
        return ourInstance;
    }

    private ShowRuleInfoAction() {
    }

    public void actionPerformed(RuleModel ruleModel) {
        int n = 0;
        int n2 = 0;
        for (String string : ruleModel.getBindings().keySet()) {
            if (!string.startsWith("(")) continue;
            AnnotationSet annotationSet = (AnnotationSet)ruleModel.getBindings().get(string);
            if (annotationSet != null) {
                try {
                    n = ((AnnotationSet)ruleModel.getBindings().get(string)).firstNode().getOffset().intValue();
                    n2 = ((AnnotationSet)ruleModel.getBindings().get(string)).lastNode().getOffset().intValue();
                    GuiFactory.getDocumentEditor().setTextSelection(Color.cyan, n, n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            GuiFactory.getDocumentEditor().setTextSelection(Color.cyan, 0, 0);
        }
        ResourcesFactory.setCurrentJapeFile(this.getJapeFile(ruleModel));
        ResourcesFactory.setCurrentJapeText(this.getJapeText());
        GuiFactory.getDebugPanel().getRulePanel().ruleSelected();
        GuiFactory.getDebugPanel().getJapeSourcePanel().upgradeTextPane();
        GuiFactory.getDebugPanel().getTraceHistoryPanel().setCurrentRule(ruleModel);
        GuiFactory.getDebugPanel().getTraceHistoryPanel().updateRulePanel(ruleModel, null);
    }

    private int getSlashNAmount(int n, AnnotationSet annotationSet) {
        try {
            String string = annotationSet.getDocument().getContent().getContent(new Long(0L), new Long(n)).toString();
            if (string.equals("")) {
                return 0;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            if (string.endsWith("\n")) {
                return stringTokenizer.countTokens();
            }
            return stringTokenizer.countTokens() - 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    private JapeFile getJapeFile(RuleModel ruleModel) {
        SinglePhaseTransducer singlePhaseTransducer = ruleModel.getParentPhase().getSPT();
        if (singlePhaseTransducer == null) {
            return null;
        }
        URL uRL = singlePhaseTransducer.getBaseURL();
        if (!uRL.toString().startsWith("file")) {
            uRL = Files.getGateResource(uRL.getPath());
        }
        if (uRL == null) {
            System.out.println("Not valid SPT BaseURL (" + singlePhaseTransducer.getBaseURL() + ")");
            return null;
        }
        JapeFile japeFile = new JapeFile(uRL);
        return japeFile;
    }

    public String getJapeText() {
        JapeFile japeFile = ResourcesFactory.getCurrentJapeFile();
        if (japeFile == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(japeFile.getReader());
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string).append("\n");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }
}

