/*
 * Decompiled with CFR 0.152.
 */
package debugger.gui.actions.editor;

import debugger.gui.GuiFactory;
import debugger.gui.actions.resources.LrResourceSelectedAction;
import debugger.resources.ResourcesFactory;
import gate.Document;
import gate.LanguageResource;
import gate.corpora.DocumentImpl;
import javax.swing.JOptionPane;

public class ShowResultAction {
    private static ShowResultAction ourInstance;

    public static synchronized ShowResultAction getInstance() {
        if (ourInstance == null) {
            ourInstance = new ShowResultAction();
        }
        return ourInstance;
    }

    private ShowResultAction() {
    }

    public void actionPerformed(int n, int n2) {
        LanguageResource languageResource = ResourcesFactory.getCurrentLrModel().getLr();
        if (languageResource instanceof Document) {
            if (!ResourcesFactory.getCurrentLrModel().getStoredContent().equals(((Document)languageResource).getContent().toString())) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "Document content changed.\nSynchronization of rule matching history with\nchanging document content not supported.\nYou should rerun pipeline again.", "Warning!", -1);
                ResourcesFactory.getCurrentLrModel().synchronize();
                LrResourceSelectedAction.getInstance().actionPerformed(ResourcesFactory.getCurrentLrModel());
                return;
            }
            int n3 = n + this.getSlashNAmount(n, (DocumentImpl)languageResource);
            int n4 = n2 + this.getSlashNAmount(n2, (DocumentImpl)languageResource);
            GuiFactory.getDebugPanel().getTraceHistoryPanel().setText(n3, n4, (Document)languageResource);
            GuiFactory.getResourceView().getResourceTreeCellRenderer().setIndexes(n3, n4);
            GuiFactory.getResourceView().repaint();
            GuiFactory.getResourceView().repaint();
        }
    }

    private int getSlashNAmount(int n, DocumentImpl documentImpl) {
        int n2 = 0;
        try {
            String string = documentImpl.getContent().getContent(new Long(0L), new Long(n)).toString();
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c != '\n') continue;
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }
}

