/*
 * Decompiled with CFR 0.152.
 */
package debugger.gui.actions.debugging;

import debugger.ClassRipper;
import debugger.JapeDebugger;
import gate.Gate;
import gate.VisualResource;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.SerialAnalyserController;
import gate.gui.SerialControllerEditor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

public class RunControllerAction
extends AbstractAction {
    private static RunControllerAction ourInstance;

    public static synchronized RunControllerAction getInstance() {
        if (ourInstance == null) {
            ourInstance = new RunControllerAction();
        }
        return ourInstance;
    }

    private RunControllerAction() {
        this.putValue("ShortDescription", new String("Run controller"));
        this.putValue("SmallIcon", new ImageIcon(JapeDebugger.class.getResource("gui/icons/controller")));
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setEnabled(false);
        for (VisualResource visualResource : Gate.getCreoleRegister().getVrInstances()) {
            if (!(visualResource instanceof SerialControllerEditor)) continue;
            SerialAnalyserController serialAnalyserController = null;
            try {
                serialAnalyserController = (SerialAnalyserController)ClassRipper.getFieldValue(visualResource, "controller");
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            if (serialAnalyserController == null) break;
            final SerialAnalyserController serialAnalyserController2 = serialAnalyserController;
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Gate.setExecutable(serialAnalyserController2);
                        serialAnalyserController2.execute();
                    }
                    catch (ExecutionInterruptedException executionInterruptedException) {
                        executionInterruptedException.printStackTrace();
                    }
                    catch (ExecutionException executionException) {
                        executionException.printStackTrace();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        Gate.setExecutable(null);
                    }
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "ApplicationViewer1");
            thread.setPriority(1);
            thread.start();
            break;
        }
    }
}

