/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClassRipper {
    private static int DebugLevel = 4;

    private ClassRipper() {
    }

    private static Field getField(Object object, String string) {
        if (DebugLevel >= 5) {
            System.out.print("DEBUG [" + ClassRipper.class.getName() + "]:");
            System.out.print(" getField: ");
            System.out.print(" classInstance = [" + object.getClass().getName() + "]");
            System.out.print(" fieldName = [" + string + "]");
            System.out.print("\n");
        }
        Field field = null;
        Class<?> clazz = object.getClass();
        while (!clazz.getName().equals("java.lang.Object")) {
            try {
                field = clazz.getDeclaredField(string);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz = clazz.getSuperclass();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
        }
        return null;
    }

    private static Method getMethod(Object object, String string, Class[] classArray) {
        if (DebugLevel >= 5) {
            System.out.print("DEBUG [" + ClassRipper.class.getName() + "]:");
            System.out.print(" getMethod: ");
            System.out.print(" classInstance = [" + object.getClass().getName() + "]");
            System.out.print(" methodName = [" + string + "]");
            System.out.print("\n");
        }
        Class<?> clazz = object.getClass();
        while (!clazz.getName().equals("java.lang.Object")) {
            try {
                Method[] methodArray = clazz.getDeclaredMethods();
                block3: for (int i = 0; i < methodArray.length; ++i) {
                    Class<?>[] classArray2;
                    if (!methodArray[i].getName().equals(string) || (classArray2 = methodArray[i].getParameterTypes()).length != classArray.length) continue;
                    for (int j = 0; j < classArray2.length; ++j) {
                        if (classArray[j] != null && !classArray2[j].isAssignableFrom(classArray[j])) continue block3;
                    }
                    methodArray[i].setAccessible(true);
                    return methodArray[i];
                }
                clazz = clazz.getSuperclass();
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
        }
        return null;
    }

    public static Object getFieldValue(Object object, String string) throws IllegalAccessException {
        Field field = ClassRipper.getField(object, string);
        Object object2 = field.get(object);
        field.setAccessible(false);
        return object2;
    }

    public static boolean getBoolean(Object object, String string) throws IllegalAccessException {
        Field field = ClassRipper.getField(object, string);
        boolean bl = field.getBoolean(object);
        field.setAccessible(false);
        return bl;
    }

    public static byte getByte(Object object, String string) throws IllegalAccessException {
        Field field = ClassRipper.getField(object, string);
        byte by = field.getByte(object);
        field.setAccessible(false);
        return by;
    }

    public static char getChar(Object object, String string) throws IllegalAccessException {
        Field field = ClassRipper.getField(object, string);
        char c = field.getChar(object);
        field.setAccessible(false);
        return c;
    }

    public static int getInt(Object object, String string) throws IllegalAccessException {
        Field field = ClassRipper.getField(object, string);
        int n = field.getInt(object);
        field.setAccessible(false);
        return n;
    }

    public static float getFloat(Object object, String string) throws IllegalAccessException {
        Field field = ClassRipper.getField(object, string);
        float f = field.getFloat(object);
        field.setAccessible(false);
        return f;
    }

    public static long getLong(Object object, String string) throws IllegalAccessException {
        Field field = ClassRipper.getField(object, string);
        long l = field.getLong(object);
        field.setAccessible(false);
        return l;
    }

    public static double getDouble(Object object, String string) throws IllegalAccessException {
        Field field = ClassRipper.getField(object, string);
        double d = field.getDouble(object);
        field.setAccessible(false);
        return d;
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray) throws InvocationTargetException, IllegalAccessException {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i] == null ? null : objectArray[i].getClass();
        }
        Method method = ClassRipper.getMethod(object, string, classArray);
        Object object2 = method.invoke(object, objectArray);
        method.setAccessible(false);
        return object2;
    }
}

