/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.gate.vr;

import com.ontotext.gate.vr.ClassNode;
import com.ontotext.gate.vr.Gaze;
import com.ontotext.gate.vr.OntoTreeModel;
import gate.creole.gazetteer.MappingDefinition;
import gate.creole.gazetteer.MappingNode;
import gate.creole.ontology.OClass;
import gate.gui.MainFrame;
import gate.util.LazyProgrammerException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class MappingTreeView
extends JTree {
    private static final long serialVersionUID = 3257568420999410744L;
    private static final String GAZ_ICON = "lr";
    private static final int EDIT_ACTION = 1;
    private static final int INSERT_ACTION = 2;
    private static final int REMOVE_ACTION = 3;
    private MappingDefinition mapping = null;
    private Gaze gaze = null;
    private JPopupMenu pupMenu = new JPopupMenu();
    private JMenuItem insertPuP = new JMenuItem("insert mapping");
    private JMenuItem removePuP = new JMenuItem("remove mapping");

    public MappingTreeView(OntoTreeModel ontoTreeModel, MappingDefinition mappingDefinition, Gaze gaze) {
        super(ontoTreeModel);
        if (null == mappingDefinition) {
            throw new LazyProgrammerException("Mapping Def cannot be null on contructing MappingTreeView");
        }
        if (null == gaze) {
            throw new LazyProgrammerException("Gazetteer Editor - Gaze VR - cannot be null on contructing MappingTreeView");
        }
        this.mapping = mappingDefinition;
        this.gaze = gaze;
        this.init();
    }

    private void init() {
        this.getSelectionModel().setSelectionMode(1);
        MappingTreeCR mappingTreeCR = new MappingTreeCR();
        mappingTreeCR.setLeafIcon(mappingTreeCR.getDefaultClosedIcon());
        this.setCellRenderer(mappingTreeCR);
        this.addMouseListener(new MyMouseAdapter());
        this.removePuP.addActionListener(new RemoveAL());
        this.insertPuP.addActionListener(new InsertAL());
        this.pupMenu.add(this.insertPuP);
        this.pupMenu.add(this.removePuP);
    }

    class InsertAL
    implements ActionListener {
        InsertAL() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            ClassNode classNode = (ClassNode)MappingTreeView.this.getLastSelectedPathComponent();
            Object object = classNode.getSource();
            if (object instanceof OClass) {
                List list = MappingTreeView.this.gaze.getLists();
                Collections.sort(list);
                Object object2 = JOptionPane.showInputDialog(MappingTreeView.this, "Map selected ontology class to a gazetteer list:", "Insert Mapping Node", -1, null, list.toArray(), null);
                if (null != object2) {
                    OClass oClass = (OClass)object;
                    MappingNode mappingNode = new MappingNode((String)object2, oClass.getOntology().getURL().toString(), classNode.toString());
                    MappingTreeView.this.mapping.add(mappingNode);
                    ClassNode classNode2 = new ClassNode(mappingNode);
                    Vector vector = classNode.children();
                    vector.add(classNode2);
                    MappingTreeView.this.updateUI();
                    MappingTreeView.this.gaze.updateMappingUI();
                }
            }
        }
    }

    class RemoveAL
    implements ActionListener {
        RemoveAL() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath;
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            ClassNode classNode = (ClassNode)MappingTreeView.this.getLastSelectedPathComponent();
            Object object = classNode.getSource();
            if (object instanceof MappingNode && null != (treePath = MappingTreeView.this.getAnchorSelectionPath().getParentPath())) {
                ClassNode classNode2 = (ClassNode)treePath.getLastPathComponent();
                Vector vector = classNode2.children();
                vector.remove(classNode);
                classNode2.setChildren(vector);
                MappingTreeView.this.mapping.remove(object);
                MappingTreeView.this.updateUI();
                MappingTreeView.this.gaze.updateMappingUI();
            }
        }
    }

    class MyMouseAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            TreePath treePath = MappingTreeView.this.getSelectionPath();
            JTree jTree = new JTree();
            ClassNode classNode = null;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && 2 == mouseEvent.getClickCount() && treePath != null && (classNode = (ClassNode)treePath.getLastPathComponent()).getSource() instanceof MappingNode) {
                MappingNode mappingNode = (MappingNode)classNode.getSource();
                MappingTreeView.this.gaze.displayList(mappingNode.getList());
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent) && treePath != null) {
                classNode = (ClassNode)treePath.getLastPathComponent();
                if (classNode.getSource() instanceof MappingNode) {
                    MappingTreeView.this.removePuP.setEnabled(true);
                    MappingTreeView.this.insertPuP.setEnabled(false);
                } else {
                    MappingTreeView.this.removePuP.setEnabled(false);
                    MappingTreeView.this.insertPuP.setEnabled(true);
                }
                MappingTreeView.this.pupMenu.show(MappingTreeView.this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class MappingTreeCR
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 3546924666926085169L;

        MappingTreeCR() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            ClassNode classNode;
            Object object2;
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof ClassNode && (object2 = (classNode = (ClassNode)object).getSource()) instanceof MappingNode) {
                this.setIcon(MainFrame.getIcon(MappingTreeView.GAZ_ICON));
            }
            return this;
        }
    }
}

