/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.gate.gazetteer;

import com.ontotext.gate.gazetteer.HashGazetteer;
import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.corpora.TestDocument;
import gate.util.Strings;
import java.net.URL;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestHashGazetteer
extends TestCase {
    private static final String GAZ_AS = "GazetteerAS";
    private static String[] DESIRED_ANNOTATIONS = new String[]{"1067-1072:date_unit.null", "1033-1038:person_first.male", "1029-1032:title.male", "1014-1023:jobtitle.null", "1008-1013:jobtitle.null", "995-1003:jobtitle.null", "846-853:number.null", "814-822:date.month", "799-802:title.male", "765-768:org_ending.null", "765-768:cdg.null", "753-764:org_key.null", "738-741:org_ending.null", "738-741:cdg.null", "723-737:org_key.null", "713-722:organization.company", "696-701:cdg.null", "677-686:organization.company", "664-673:jobtitle.null", "658-663:jobtitle.null", "645-653:jobtitle.null", "636-641:date_unit.null", "614-616:stop.null", "603-613:organization.company", "582-587:cdg.null", "555-576:organization.company", "546-549:org_ending.null", "546-549:cdg.null", "529-538:jobtitle.null", "523-528:jobtitle.null", "510-518:jobtitle.null", "484-487:title.male", "465-473:jobtitle.null", "424-429:person_first.male", "414-420:person_first.male", "394-399:date_unit.null", "379-382:title.male", "350-373:jobtitle.null", "337-345:jobtitle.null", "320-325:person_first.male", "295-298:org_ending.null", "295-298:cdg.null", "274-277:location.province", "265-272:location.city", "182-189:cdg.null", "161-165:person_first.female", "100-115:title.civilian", "100-115:jobtitle.null", "87-95:title.civilian"};

    public TestHashGazetteer(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testHashGazetteer() throws Exception {
        Document document = Factory.newDocument(new URL(TestDocument.getTestServerName() + "tests/doc0.html"));
        FeatureMap featureMap = Factory.newFeatureMap();
        HashGazetteer hashGazetteer = (HashGazetteer)Factory.createResource("com.ontotext.gate.gazetteer.HashGazetteer", featureMap);
        hashGazetteer.setDocument(document);
        hashGazetteer.setAnnotationSetName(GAZ_AS);
        hashGazetteer.execute();
        TestHashGazetteer.assertTrue((String)"the Annotation set resulting of the execution of the OntoText Natural Gazetteer is empty.", (!document.getAnnotations(GAZ_AS).isEmpty() ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(TestHashGazetteer.class);
    }

    public static void main(String[] stringArray) {
        try {
            Gate.init();
            TestHashGazetteer testHashGazetteer = new TestHashGazetteer("");
            testHashGazetteer.setUp();
            testHashGazetteer.testHashGazetteer();
            testHashGazetteer.tearDown();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void dumpAnnotationSet(AnnotationSet annotationSet) {
        if (annotationSet != null) {
            for (Annotation annotation : annotationSet) {
                FeatureMap featureMap = annotation.getFeatures();
                String string = (String)featureMap.get("majorType");
                String string2 = (String)featureMap.get("minorType");
                String string3 = " " + annotation.getStartNode().getOffset() + "-" + annotation.getEndNode().getOffset();
                System.out.println(string3 + ":" + string + "." + string2 + Strings.getNl());
            }
        }
    }

    private boolean EqualAnnotationSets(AnnotationSet annotationSet) {
        boolean bl = true;
        String string = null;
        int n = 0;
        boolean bl2 = bl = bl && annotationSet.size() == DESIRED_ANNOTATIONS.length;
        if (annotationSet != null) {
            Iterator<Annotation> iterator = annotationSet.iterator();
            while (iterator.hasNext() & bl) {
                Annotation annotation = iterator.next();
                FeatureMap featureMap = annotation.getFeatures();
                String string2 = (String)featureMap.get("majorType");
                String string3 = (String)featureMap.get("minorType");
                String string4 = "" + annotation.getStartNode().getOffset() + "-" + annotation.getEndNode().getOffset();
                string = string4 + ":" + string2 + "." + string3;
                bl = bl && string.equals(DESIRED_ANNOTATIONS[n]);
                ++n;
            }
        } else {
            bl = false;
        }
        return bl;
    }
}

