/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;
import net.arnx.jsonic.util.BeanInfo;
import net.arnx.jsonic.util.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectFormatter
implements Formatter {
    private Class<?> cls;
    private transient List<PropertyInfo> props;

    public ObjectFormatter(Class<?> clazz) {
        this.cls = clazz;
    }

    @Override
    public boolean format(JSON.Context context, Object object, Object object2, OutputSource outputSource) throws Exception {
        int n;
        if (this.props == null) {
            this.props = ObjectFormatter.getGetProperties(context, this.cls);
        }
        outputSource.append('{');
        int n2 = 0;
        int n3 = this.props.size();
        for (n = 0; n < n3; ++n) {
            PropertyInfo propertyInfo = this.props.get(n);
            Object object3 = null;
            Exception exception = null;
            try {
                object3 = propertyInfo.get(object2);
                if (object3 == object || context.isSuppressNull() && object3 == null) continue;
                if (n2 != 0) {
                    outputSource.append(',');
                }
                if (context.isPrettyPrint()) {
                    outputSource.append('\n');
                    int n4 = context.getInitialIndent() + context.getDepth() + 1;
                    for (int i = 0; i < n4; ++i) {
                        outputSource.append(context.getIndentText());
                    }
                }
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            StringFormatter.serialize(context, propertyInfo.getName(), outputSource);
            outputSource.append(':');
            if (context.isPrettyPrint()) {
                outputSource.append(' ');
            }
            context.enter(propertyInfo.getName(), propertyInfo.getReadAnnotation(JSONHint.class));
            if (exception != null) {
                throw exception;
            }
            object3 = context.preformatInternal(object3);
            context.formatInternal(object3, outputSource);
            context.exit();
            ++n2;
        }
        if (context.isPrettyPrint() && n2 > 0) {
            outputSource.append('\n');
            n = context.getInitialIndent() + context.getDepth();
            for (int i = 0; i < n; ++i) {
                outputSource.append(context.getIndentText());
            }
        }
        outputSource.append('}');
        return true;
    }

    static List<PropertyInfo> getGetProperties(JSON.Context context, Class<?> clazz) {
        int n;
        String string;
        JSONHint jSONHint;
        AccessibleObject accessibleObject;
        HashMap<String, PropertyInfo> hashMap = new HashMap<String, PropertyInfo>();
        for (PropertyInfo propertyInfo : BeanInfo.get(clazz).getProperties()) {
            accessibleObject = propertyInfo.getField();
            if (accessibleObject == null || context.ignoreInternal(clazz, (Member)((Object)accessibleObject))) continue;
            jSONHint = ((Field)accessibleObject).getAnnotation(JSONHint.class);
            string = null;
            n = propertyInfo.getOrdinal();
            if (jSONHint != null) {
                if (jSONHint.ignore()) continue;
                n = jSONHint.ordinal();
                if (jSONHint.name().length() != 0) {
                    string = jSONHint.name();
                }
            }
            if (string == null) {
                string = context.normalizeInternal(propertyInfo.getName());
                if (context.getPropertyStyle() != null) {
                    string = context.getPropertyStyle().to(string);
                }
            }
            if (!string.equals(propertyInfo.getName()) || n != propertyInfo.getOrdinal() || accessibleObject != propertyInfo.getReadMember()) {
                hashMap.put(string, new PropertyInfo(propertyInfo.getBeanClass(), string, propertyInfo.getField(), null, null, propertyInfo.isStatic(), n));
                continue;
            }
            hashMap.put(string, propertyInfo);
        }
        for (PropertyInfo propertyInfo : BeanInfo.get(clazz).getProperties()) {
            accessibleObject = propertyInfo.getReadMethod();
            if (accessibleObject == null || context.ignoreInternal(clazz, (Member)((Object)accessibleObject))) continue;
            jSONHint = ((Method)accessibleObject).getAnnotation(JSONHint.class);
            string = null;
            n = propertyInfo.getOrdinal();
            if (jSONHint != null) {
                if (jSONHint.ignore()) continue;
                n = jSONHint.ordinal();
                if (jSONHint.name().length() != 0) {
                    string = jSONHint.name();
                }
            }
            if (string == null) {
                string = context.normalizeInternal(propertyInfo.getName());
                if (context.getPropertyStyle() != null) {
                    string = context.getPropertyStyle().to(string);
                }
            }
            if (!string.equals(propertyInfo.getName()) || n != propertyInfo.getOrdinal()) {
                hashMap.put(string, new PropertyInfo(propertyInfo.getBeanClass(), string, null, propertyInfo.getReadMethod(), null, propertyInfo.isStatic(), n));
                continue;
            }
            hashMap.put(string, propertyInfo);
        }
        ArrayList arrayList = new ArrayList(hashMap.values());
        Collections.sort(arrayList);
        return arrayList;
    }
}

