/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server.tests;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import edu.northwestern.at.morphadorner.server.WordTokenizerResult;
import edu.northwestern.at.morphadorner.server.tests.BaseTest;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;

public class TestWordTokenizerService
extends BaseTest {
    protected static String sampleText = "Mary had a little lamb whose fleece was white as snow.";
    protected static String[] tokens = new String[]{"Mary", "had", "a", "little", "lamb", "whose", "fleece", "was", "white", "as", "snow", "."};

    @Test
    public void testWordTokenizerService() {
        ClientResource resource = this.createClientResource("wordtokenizer");
        resource.addQueryParameter("text", sampleText);
        resource.addQueryParameter("corpusConfig", "ncf");
        resource.addQueryParameter("media", "xml");
        try {
            Representation xmlResult = resource.get();
            XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
            xstream.alias("token", String.class);
            xstream.alias("sentence", ArrayList.class);
            xstream.alias("WordTokenizerResult", WordTokenizerResult.class);
            WordTokenizerResult result = (WordTokenizerResult)xstream.fromXML(xmlResult.getText());
            Assert.assertEquals((long)1L, (long)result.sentences.size());
            List<String> sentence = result.sentences.get(0);
            Assert.assertEquals((long)tokens.length, (long)sentence.size());
            for (int i = 0; i < sentence.size(); ++i) {
                Assert.assertEquals((Object)sentence.get(i), (Object)tokens[i]);
            }
            System.out.println("Tokens: " + sentence);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            Assert.fail();
        }
    }
}

