/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server.tests;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import edu.northwestern.at.morphadorner.server.SentenceSplitterResult;
import edu.northwestern.at.morphadorner.server.tests.BaseTest;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;

public class TestSentenceSplitterService
extends BaseTest {
    protected static String sampleText = "Mary had a little lamb whose fleece was white as snow. And everywhere that Mary went the lamb was sure to go.";
    protected static String[] tokens = new String[]{"Mary", "had", "a", "little", "lamb", "whose", "fleece", "was", "white", "as", "snow", ".", "And", "everywhere", "that", "Mary", "went", "the", "lamb", "was", "sure", "to", "go", "."};
    protected static int sentenceCount = 2;

    @Test
    public void testSentenceSplitterService() {
        ClientResource resource = this.createClientResource("sentencesplitter");
        resource.addQueryParameter("text", sampleText);
        resource.addQueryParameter("corpusConfig", "ncf");
        resource.addQueryParameter("media", "xml");
        try {
            int i;
            Representation xmlResult = resource.get();
            XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
            xstream.alias("token", String.class);
            xstream.alias("sentence", ArrayList.class);
            xstream.alias("meldedSentence", String.class);
            xstream.alias("meldedSentences", ArrayList.class);
            xstream.alias("SentenceSplitterResult", SentenceSplitterResult.class);
            SentenceSplitterResult result = (SentenceSplitterResult)xstream.fromXML(xmlResult.getText());
            int tokenCount = 0;
            for (i = 0; i < result.sentences.size(); ++i) {
                tokenCount += ((List)result.sentences.get(i)).size();
            }
            Assert.assertEquals((long)tokens.length, (long)tokenCount);
            Assert.assertEquals((long)sentenceCount, (long)result.meldedSentences.size());
            System.out.println("# of sentences: " + result.meldedSentences.size());
            for (i = 0; i < result.meldedSentences.size(); ++i) {
                System.out.println(i + ": " + result.meldedSentences.get(i));
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            Assert.fail();
        }
    }
}

