/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server.tests;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import edu.northwestern.at.morphadorner.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.morphadorner.corpuslinguistics.adornedword.BaseAdornedWord;
import edu.northwestern.at.morphadorner.server.PartOfSpeechTaggerResult;
import edu.northwestern.at.morphadorner.server.tests.BaseTest;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;

public class TestPartOfSpeechTaggerService
extends BaseTest {
    protected static String sampleText = "Mary had a little lamb whose fleece was white as snow.";
    protected static String[] tokens = new String[]{"Mary", "had", "a", "little", "lamb", "whose", "fleece", "was", "white", "as", "snow", "."};

    @Test
    public void testPartOfSpeechTaggerService() {
        ClientResource resource = this.createClientResource("partofspeechtagger");
        resource.addQueryParameter("text", sampleText);
        resource.addQueryParameter("corpusConfig", "ncf");
        resource.addQueryParameter("media", "xml");
        try {
            Representation xmlResult = resource.get();
            XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
            xstream.alias("token", String.class);
            xstream.alias("sentence", ArrayList.class);
            xstream.alias("adornedSentence", ArrayList.class);
            xstream.alias("adornedWord", BaseAdornedWord.class);
            xstream.alias("PartOfSpeechTaggerResult", PartOfSpeechTaggerResult.class);
            PartOfSpeechTaggerResult result = null;
            try {
                result = (PartOfSpeechTaggerResult)xstream.fromXML(xmlResult.getText());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail();
            }
            Assert.assertEquals((long)1L, (long)result.sentences.size());
            List tokSentence = (List)result.sentences.get(0);
            Assert.assertEquals((long)tokens.length, (long)tokSentence.size());
            for (int i = 0; i < result.adornedSentences.size(); ++i) {
                List<AdornedWord> sentence = result.adornedSentences.get(i);
                for (int j = 0; j < sentence.size(); ++j) {
                    AdornedWord adornedWord = sentence.get(j);
                    System.out.println("token: " + adornedWord + ", pos: " + adornedWord.getPartsOfSpeech() + ", lemma: " + adornedWord.getLemmata());
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            Assert.fail();
        }
    }
}

