/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server.tests;

import edu.northwestern.at.morphadorner.server.tests.BaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.restlet.resource.ClientResource;

public class TestParserService
extends BaseTest {
    protected static String sampleText = "Mary had a little lamb whose fleece was white as snow.";
    protected static String[] expectedParse = new String[]{"+------------------------------------Xp-----------------------------------+", "|            +-------Os------+                                            |", "+---Wd--+-Ss-+   +IDDC+--Dmu-+--Mr-+--Dmuw-+--Ss--+--Pa--+--MVz-+-Osc-+   |", "|       |    |   |    |      |     |       |      |      |      |     |   |", "LEFT-WALL Mary had.v a little lamb.n whose fleece.n was.v white.a as.z snow.n .", "        LEFT-WALL  Xp    <---Xp---->  Xp    .", "(m)     LEFT-WALL  Wd    <---Wd---->  Wd    Mary", "(m)     Mary       Ss    <---Ss---->  S     had.v", "(m)     had.v      O     <---Os---->  Os    lamb.n", "(m)     little     Dmu   <---Dmu--->  D*u   lamb.n", "(m)     a          IDDC  <---IDDC-->  IDDC  little", "(m)(r)  lamb.n     M     <---Mr---->  Mr    whose", "(m)(r)  whose      D**w  <---Dmuw-->  Dmu   fleece.n", "(m)(r)  fleece.n   Ss    <---Ss---->  Ss    was.v", "(m)(r)  was.v      Pa    <---Pa---->  Pa    white.a", "(m)(r)  white.a    MV    <---MVz--->  MVz   as.z", "(m)(r)  as.z       O*c   <---Osc--->  Os    snow.n", "        .          RW    <---RW---->  RW    RIGHT-WALL"};

    @Test
    public void testParserService() {
        ClientResource resource = this.createClientResource("parser");
        resource.addQueryParameter("text", sampleText);
        resource.addQueryParameter("media", "text");
        try {
            String result = (String)resource.get(String.class);
            System.out.println("Sentence: " + sampleText);
            String[] lines = result.split("\n");
            int k = 0;
            boolean ok = true;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i].trim();
                System.out.println(line);
                if (line.length() <= 0) continue;
                boolean bl = ok = ok && line.equals(expectedParse[k].trim());
                if (!line.equals(expectedParse[k].trim())) {
                    System.out.println("Line " + i + " doesn't match expected line " + k);
                    System.out.println("   " + i + ": " + line);
                    System.out.println("   " + k + ": " + expectedParse[k]);
                }
                ++k;
            }
            Assert.assertTrue((boolean)ok);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            Assert.fail();
        }
    }
}

