/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server.tests;

import edu.northwestern.at.morphadorner.server.LanguageRecognizerResult;
import edu.northwestern.at.morphadorner.server.ScoredLanguage;
import edu.northwestern.at.morphadorner.server.tests.BaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.restlet.resource.ClientResource;

public class TestLanguageRecognizerService
extends BaseTest {
    protected static String frenchText = "Au clair de la lune Mon ami Pierrot Pr\u00eate-moi ta plume Pour \u00e9crire un mot Ma chandelle est morte Je n'ai plus de feu Ouvre-moi ta porte Pour l'amour de Dieu.";
    protected static String italianText = "Caro mio ben, credimi almen, senza di te languisce il cor. Il tuo fedel sospira ognor. Cessa, crudel, tanto rigor!";
    protected static String englishText = "Mary had a little lamb, whose fleece was white as snow. And everywhere that Mary went, the lamb was sure to go.";

    @Test
    public void testLanguageRecognizedrService() {
        ClientResource resource = this.createClientResource("languagerecognizer");
        resource.addQueryParameter("text", englishText);
        resource.addQueryParameter("media", "xml");
        try {
            LanguageRecognizerResult result = (LanguageRecognizerResult)resource.get(LanguageRecognizerResult.class);
            ScoredLanguage language = result.languages.get(0);
            Assert.assertEquals((Object)language.getLanguageCode(), (Object)"en");
            System.out.println(result);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            Assert.fail();
        }
        ClientResource resource2 = this.createClientResource("languagerecognizer", false);
        resource2.addQueryParameter("text", frenchText);
        resource2.addQueryParameter("media", "xml");
        try {
            LanguageRecognizerResult result2 = (LanguageRecognizerResult)resource2.get(LanguageRecognizerResult.class);
            ScoredLanguage language = result2.languages.get(0);
            Assert.assertEquals((Object)language.getLanguageCode(), (Object)"fr");
            System.out.println(result2);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            Assert.fail();
        }
        ClientResource resource3 = this.createClientResource("languagerecognizer", false);
        resource3.addQueryParameter("text", italianText);
        resource3.addQueryParameter("media", "xml");
        try {
            LanguageRecognizerResult result3 = (LanguageRecognizerResult)resource3.get(LanguageRecognizerResult.class);
            ScoredLanguage language = result3.languages.get(0);
            Assert.assertEquals((Object)language.getLanguageCode(), (Object)"it");
            System.out.println(result3);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            Assert.fail();
        }
    }
}

