/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server.converters;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.HashSet;
import java.util.Set;

public class AliasingSetConverter
implements Converter {
    private Class<?> type;
    private String alias;

    public AliasingSetConverter(Class<?> type, String alias) {
        this.type = type;
        this.alias = alias;
    }

    public boolean canConvert(Class type) {
        return Set.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Set set = (Set)source;
        for (Object elem : set) {
            if (!elem.getClass().isAssignableFrom(this.type)) {
                throw new ConversionException("Found " + elem.getClass() + ", expected to find: " + this.type + " in Set.");
            }
            ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)this.alias, elem.getClass());
            context.convertAnother(elem);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        HashSet<Object> set = new HashSet<Object>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            set.add(context.convertAnother(set, this.type));
            reader.moveUp();
        }
        return set;
    }
}

