/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server.converters;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class AliasingListConverter
implements Converter {
    protected Class<?> type;
    protected String alias;

    public AliasingListConverter(Class<?> type, String alias) {
        this.type = type;
        this.alias = alias;
    }

    public boolean canConvert(Class type) {
        return List.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        List list = (List)source;
        for (Object elem : list) {
            if (!elem.getClass().isAssignableFrom(this.type)) {
                throw new ConversionException("Found " + elem.getClass() + ", expected to find: " + this.type + " in List.");
            }
            ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)this.alias, elem.getClass());
            context.convertAnother(elem);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            list.add(context.convertAnother(list, this.type));
            reader.moveUp();
        }
        return list;
    }
}

