/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer.TokenizerUtils;
import edu.northwestern.at.morphadorner.server.BaseResults;
import edu.northwestern.at.morphadorner.server.converters.ListOfListOfTokensConverter;
import edu.northwestern.at.utils.Formatters;
import java.util.List;

@XStreamAlias(value="WordTokenizerResult")
public class WordTokenizerResult
extends BaseResults {
    public String text;
    public String langCode;
    public String corpusConfig;
    @XStreamConverter(value=ListOfListOfTokensConverter.class)
    public List<List<String>> sentences;

    public WordTokenizerResult() {
        this.text = "";
        this.langCode = "";
        this.corpusConfig = "";
        this.sentences = null;
    }

    public WordTokenizerResult(String text, String langCode, String corpusConfig, List<List<String>> sentences) {
        this.text = text;
        this.langCode = langCode;
        this.corpusConfig = corpusConfig;
        this.sentences = sentences;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int nWords = 0;
        for (int i = 0; i < this.sentences.size(); ++i) {
            nWords += this.sentences.get(i).size();
        }
        int nSent = this.sentences.size();
        switch (nSent) {
            case 0: {
                sb.append("No words found.\n");
                break;
            }
            case 1: {
                if (nWords == 1) {
                    sb.append("1 word in 1 sentence.\n");
                    break;
                }
                sb.append(Formatters.formatIntegerWithCommas((int)nWords) + " words in 1 sentence.\n");
                break;
            }
            default: {
                sb.append(Formatters.formatIntegerWithCommas((int)nWords) + " words in " + Formatters.formatIntegerWithCommas((int)nSent) + " sentences found.\n");
            }
        }
        sb.append("S#\tW#\tToken\tType\n");
        for (int i = 0; i < nSent; ++i) {
            List<String> sentence = this.sentences.get(i);
            for (int j = 0; j < sentence.size(); ++j) {
                sb.append(i + 1 + "\t");
                sb.append(j + 1 + "\t");
                sb.append(sentence.get(j));
                sb.append("\t");
                sb.append(TokenizerUtils.getTokenType((String)sentence.get(j)));
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

