/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.engine.Engine;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;

public class WADLConverter {
    public static Templates templates;

    public static Representation createHtmlRepresentation(String xml) {
        Representation representation = null;
        try {
            Transformer transformer = templates.newTransformer();
            StreamSource inputXML = new StreamSource(new StringReader(xml));
            StringWriter writer = new StringWriter();
            StreamResult outputHTML = new StreamResult(writer);
            transformer.transform(inputXML, outputHTML);
            return new StringRepresentation((CharSequence)writer.toString(), MediaType.TEXT_HTML);
        }
        catch (Exception e) {
            Context.getCurrent().getLogger().log(Level.WARNING, "Unable to generate the WADL HTML representation", e);
            return representation;
        }
    }

    protected WADLConverter() {
    }

    static {
        TransformerFactory factory = TransformerFactory.newInstance();
        URL wadl2htmlXsltUrl = Engine.getResource((String)"edu/northwestern/at/morphadorner/server/resources/wadl.xsl");
        try {
            StreamSource xslSource = new StreamSource(wadl2htmlXsltUrl.openStream());
            templates = factory.newTemplates(xslSource);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

