/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.Person;
import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.VerbTense;
import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.VerbConjugatorResult;
import edu.northwestern.at.utils.StringUtils;
import java.util.List;
import org.restlet.data.Form;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class VerbConjugatorResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("Verb conjugator resource");
        this.setDescription("Conjugates a verb.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        return this.postResults(queryParams, this.conjugate(queryParams));
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        return this.postResults(queryParams, this.conjugate(queryParams));
    }

    public VerbConjugatorResult conjugate(Form queryParams) {
        String sAmerican;
        String infinitive = StringUtils.safeString((String)queryParams.getFirstValue("infinitive")).trim();
        if ((infinitive = infinitive.toLowerCase()).startsWith("to ")) {
            infinitive = infinitive.substring(2).trim();
        }
        boolean american = (sAmerican = StringUtils.safeString((String)queryParams.getFirstValue("american")).trim()).equals("1") || sAmerican.equals("true");
        String sVerbTense = StringUtils.safeString((String)queryParams.getFirstValue("verbTense")).trim();
        VerbTense verbTense = VerbTense.PRESENT;
        if (sVerbTense.equals("present")) {
            verbTense = VerbTense.PRESENT;
        } else if (sVerbTense.equals("presentParticiple")) {
            verbTense = VerbTense.PRESENT_PARTICIPLE;
        } else if (sVerbTense.equals("past")) {
            verbTense = VerbTense.PAST;
        } else if (sVerbTense.equals("pastParticiple")) {
            verbTense = VerbTense.PAST_PARTICIPLE;
        }
        String firstPersonSingular = "";
        String secondPersonSingular = "";
        String thirdPersonSingular = "";
        String firstPersonPlural = "";
        String secondPersonPlural = "";
        String thirdPersonPlural = "";
        if (infinitive.length() != 0) {
            firstPersonSingular = MorphAdornerServerData.inflector.conjugate(infinitive, verbTense, Person.FIRST_PERSON_SINGULAR);
            secondPersonSingular = MorphAdornerServerData.inflector.conjugate(infinitive, verbTense, Person.SECOND_PERSON_SINGULAR);
            thirdPersonSingular = MorphAdornerServerData.inflector.conjugate(infinitive, verbTense, Person.THIRD_PERSON_SINGULAR);
            firstPersonPlural = MorphAdornerServerData.inflector.conjugate(infinitive, verbTense, Person.FIRST_PERSON_PLURAL);
            secondPersonPlural = MorphAdornerServerData.inflector.conjugate(infinitive, verbTense, Person.SECOND_PERSON_PLURAL);
            thirdPersonPlural = MorphAdornerServerData.inflector.conjugate(infinitive, verbTense, Person.THIRD_PERSON_PLURAL);
            if (american) {
                firstPersonSingular = MorphAdornerServerData.britishToUS.mapSpelling(firstPersonSingular);
                secondPersonSingular = MorphAdornerServerData.britishToUS.mapSpelling(secondPersonSingular);
                thirdPersonSingular = MorphAdornerServerData.britishToUS.mapSpelling(thirdPersonSingular);
                firstPersonPlural = MorphAdornerServerData.britishToUS.mapSpelling(firstPersonPlural);
                secondPersonPlural = MorphAdornerServerData.britishToUS.mapSpelling(secondPersonPlural);
                thirdPersonPlural = MorphAdornerServerData.britishToUS.mapSpelling(thirdPersonPlural);
            }
        }
        return new VerbConjugatorResult(infinitive, verbTense, american, firstPersonSingular, secondPersonSingular, thirdPersonSingular, firstPersonPlural, secondPersonPlural, thirdPersonPlural);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        List<ParameterInfo> params = super.describeParameters();
        ParameterInfo param = new ParameterInfo("infinitive", true, WADLSTRING, ParameterStyle.QUERY, "Infinitive of verb to conjugate.");
        params.add(param);
        param = new ParameterInfo("american", true, WADLBOOLEAN, ParameterStyle.QUERY, "Use American spelling.");
        params.add(param);
        param = new ParameterInfo("verbTense", true, WADLSTRING, ParameterStyle.QUERY, "Verb tense for which to derive conjugation.");
        params.add(param);
        return this.sortParams(params);
    }
}

