/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.logging.MorphAdornerServerLogger;
import edu.northwestern.at.utils.DirUtils;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.SetFactory;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.restlet.Request;
import org.restlet.ext.fileupload.RestletFileUpload;

public class UploadedFileProcessor {
    public Map<String, String> params = MapFactory.createNewMap();
    public Map<String, String> fileNameMap = MapFactory.createNewMap();
    public Map<String, String> fullFileNameMap = MapFactory.createNewMap();
    public List<String> filesToDelete = ListFactory.createNewList();
    public List<String> dirsToDelete = ListFactory.createNewList();
    public boolean foundFiles = false;

    public UploadedFileProcessor(Request request, String[] fileParamNames, int maxUploadSize) throws Exception {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        RestletFileUpload upload = new RestletFileUpload((FileItemFactory)factory);
        upload.setFileSizeMax((long)maxUploadSize);
        List fileItems = upload.parseRequest(request);
        Set fileParamNamesSet = SetFactory.createNewSet();
        fileParamNamesSet.addAll(Arrays.asList(fileParamNames));
        Map foundFilesMap = MapFactory.createNewMap();
        for (String fileParamName : fileParamNamesSet) {
            foundFilesMap.put(fileParamName, false);
        }
        for (FileItem fileItem : fileItems) {
            String fieldName = fileItem.getFieldName();
            if (fileParamNamesSet.contains(fieldName)) {
                String fileName = fileItem.getName();
                if (fileName == null || fileName.length() == 0) continue;
                foundFilesMap.put(fieldName, true);
                this.fileNameMap.put(fieldName, fileName);
                File fTempDir = this.getTemporaryDirectory();
                String tempDir = fTempDir.getCanonicalPath();
                this.addTempDirectory(tempDir);
                fTempDir.mkdirs();
                File fTempName = new File(tempDir, fileName);
                String fullFileName = fTempName.getCanonicalPath();
                this.fullFileNameMap.put(fieldName, fullFileName);
                this.addTempFile(fullFileName);
                FileUtils.createPathForFile((String)fullFileName);
                File file = new File(fullFileName);
                fileItem.write(file);
            } else {
                this.params.put(fieldName, new String(fileItem.get(), "utf-8"));
            }
            for (String fileName : foundFilesMap.keySet()) {
                this.foundFiles = this.foundFiles || (Boolean)foundFilesMap.get(fileName) != false;
            }
        }
    }

    public UploadedFileProcessor(Request request, String fileParamName, int maxUploadSize) throws Exception {
        this(request, new String[]{fileParamName}, maxUploadSize);
    }

    public File getTemporaryDirectory() {
        return DirUtils.createTemporaryDirectory((String)"zz");
    }

    public String getFileName(String fieldName) {
        return this.fileNameMap.get(fieldName);
    }

    public String getFullFileName(String fieldName) {
        return this.fullFileNameMap.get(fieldName);
    }

    public void addTempFile(String fileName) {
        this.filesToDelete.add(fileName);
    }

    public void addTempDirectory(String dirName) {
        this.dirsToDelete.add(dirName);
    }

    public List<String> getTempDirectories() {
        return this.dirsToDelete;
    }

    public List<String> getTempFiles() {
        return this.filesToDelete;
    }

    public void deleteTemporaryFilesAndDirectories() {
        int i;
        String curDir = FileUtils.getCurrentDirectory();
        MorphAdornerServerLogger.logger.log((Priority)Level.INFO, (Object)("deleteTemporaryFilesAndDirectories: current directory is " + curDir));
        for (i = 0; i < this.filesToDelete.size(); ++i) {
            MorphAdornerServerLogger.logger.log((Priority)Level.INFO, (Object)("deleteTemporaryFilesAndDirectories: deleting file " + this.filesToDelete.get(i)));
            FileUtils.deleteFile((String)this.filesToDelete.get(i));
        }
        Collections.sort(this.dirsToDelete);
        for (i = this.dirsToDelete.size() - 1; i >= 0; --i) {
            MorphAdornerServerLogger.logger.log((Priority)Level.INFO, (Object)("deleteTemporaryFilesAndDirectories: deleting directory " + this.dirsToDelete.get(i)));
            DirUtils.deleteDirectory((String)this.dirsToDelete.get(i));
        }
    }
}

