/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import edu.northwestern.at.morphadorner.server.BaseResults;
import edu.northwestern.at.morphadorner.server.converters.AntonymsListConverter;
import edu.northwestern.at.morphadorner.server.converters.SynonymsListConverter;
import edu.northwestern.at.utils.Formatters;
import java.util.List;

@XStreamAlias(value="ThesaurusResult")
public class ThesaurusResult
extends BaseResults {
    public String spelling;
    public String wordClass;
    public boolean addSynAnt;
    @XStreamConverter(value=SynonymsListConverter.class)
    public List<String> synonyms;
    @XStreamConverter(value=AntonymsListConverter.class)
    public List<String> antonyms;

    public ThesaurusResult() {
        this.spelling = "";
        this.wordClass = "";
        this.addSynAnt = false;
        this.synonyms = null;
        this.antonyms = null;
    }

    public ThesaurusResult(String spelling, String wordClass, boolean addSynAnt, List<String> synonyms, List<String> antonyms) {
        this.spelling = spelling;
        this.wordClass = wordClass;
        this.addSynAnt = addSynAnt;
        this.synonyms = synonyms;
        this.antonyms = antonyms;
    }

    public String toString() {
        return this.stringFromHTML();
    }

    @Override
    public String toHTML() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("<h3>\n");
        int nSynonyms = this.synonyms.size();
        int nAntonyms = this.antonyms.size();
        String asWordClass = "";
        if (this.wordClass.length() > 0) {
            asWordClass = " as " + this.wordClass;
        }
        switch (nSynonyms) {
            case 0: {
                sb.append("No synonyms found for " + this.spelling + asWordClass + ".\n");
                break;
            }
            case 1: {
                sb.append("1 synonym found for " + this.spelling + asWordClass + ".\n");
                break;
            }
            default: {
                sb.append(Formatters.formatIntegerWithCommas((int)nSynonyms) + " synonyms found for " + this.spelling + asWordClass + ".\n");
            }
        }
        sb.append("</h3>\n");
        sb.append("<table border=\"0\">\n");
        for (i = 0; i < this.synonyms.size(); ++i) {
            String synonym = this.synonyms.get(i);
            sb.append("<tr><td>");
            sb.append(synonym);
            sb.append("</td></tr>\n");
        }
        sb.append("</table>\n");
        sb.append("<h3>\n");
        switch (nAntonyms) {
            case 0: {
                sb.append("No antonyms found for " + this.spelling + asWordClass + ".\n");
                break;
            }
            case 1: {
                sb.append("1 antonym found for " + this.spelling + asWordClass + ".\n");
                break;
            }
            default: {
                sb.append(Formatters.formatIntegerWithCommas((int)nAntonyms) + " antonyms found for " + this.spelling + asWordClass + ".\n");
            }
        }
        sb.append("</h3>\n");
        sb.append("<table border=\"0\">\n");
        for (i = 0; i < this.antonyms.size(); ++i) {
            String antonym = this.antonyms.get(i);
            sb.append("<tr><td>");
            sb.append(antonym);
            sb.append("</td></tr>\n");
        }
        sb.append("</table>\n");
        return sb.toString();
    }
}

