/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.ThesaurusResult;
import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.StringUtils;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.restlet.data.Form;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class ThesaurusResource
extends BaseAdornerServerResource {
    protected static Set<String> allowedWordClasses = SetFactory.createNewSet();

    protected void doInit() throws ResourceException {
        this.setName("Thesaurus resource");
        this.setDescription("Finds synonyms and antonyms for a word.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        return this.postResults(queryParams, this.thesaurusLookup(queryParams));
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        return this.postResults(queryParams, this.thesaurusLookup(queryParams));
    }

    public ThesaurusResult thesaurusLookup(Form queryParams) {
        String spelling = StringUtils.safeString((String)queryParams.getFirstValue("spelling")).trim();
        String wordClass = StringUtils.safeString((String)queryParams.getFirstValue("wordClass")).trim();
        boolean addSynAnt = ThesaurusResource.getBooleanValue(StringUtils.safeString((String)queryParams.getFirstValue("addSynAnt")).trim(), false);
        if (wordClass.length() > 0 && !allowedWordClasses.contains(wordClass)) {
            wordClass = "";
        }
        List synonyms = null;
        List antonyms = null;
        if (spelling.length() > 0) {
            synonyms = MorphAdornerServerData.thesaurus.getSynonyms(spelling, wordClass);
            antonyms = MorphAdornerServerData.thesaurus.getAntonyms(spelling, wordClass);
            if (addSynAnt) {
                SortedSet moreAntonyms = SetFactory.createNewSortedSet();
                for (int i = 0; i < antonyms.size(); ++i) {
                    moreAntonyms.addAll(MorphAdornerServerData.thesaurus.getSynonyms((String)antonyms.get(i), wordClass));
                }
                antonyms.clear();
                antonyms.addAll(moreAntonyms);
            }
        }
        return new ThesaurusResult(spelling, wordClass, addSynAnt, synonyms, antonyms);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        List<ParameterInfo> params = super.describeParameters();
        ParameterInfo param = new ParameterInfo("spelling", true, WADLSTRING, ParameterStyle.QUERY, "Spelling for which to find synonyms and antonyms.");
        params.add(param);
        param = new ParameterInfo("wordClass", true, WADLSTRING, ParameterStyle.QUERY, "Word class of spelling.");
        params.add(param);
        param = new ParameterInfo("addSynAnt", true, WADLSTRING, ParameterStyle.QUERY, "Add synonyms for each antonym to antonyms list.");
        params.add(param);
        return this.sortParams(params);
    }

    static {
        allowedWordClasses.add("noun");
        allowedWordClasses.add("verb");
        allowedWordClasses.add("adjective");
        allowedWordClasses.add("adverb");
    }
}

