/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import edu.northwestern.at.morphadorner.corpuslinguistics.sentencemelder.SentenceMelder;
import edu.northwestern.at.morphadorner.server.BaseResults;
import edu.northwestern.at.morphadorner.server.converters.ListOfListOfTokensConverter;
import edu.northwestern.at.morphadorner.server.converters.SegmentTextsListConverter;
import edu.northwestern.at.utils.ListFactory;
import java.util.List;

@XStreamAlias(value="TextSegmenterResult")
public class TextSegmenterResult
extends BaseResults {
    public String text;
    public String corpusConfig;
    public int c99MaskSize;
    public int c99SegmentsWanted;
    public int tilerSlidingWindowSize;
    public int tilerStepSize;
    @XStreamConverter(value=ListOfListOfTokensConverter.class)
    public List<List<String>> sentences;
    public List<Integer> segments;
    public String segmenterName;
    @XStreamConverter(value=SegmentTextsListConverter.class)
    public List<String> segmentTexts;

    public TextSegmenterResult() {
        this.text = "";
        this.corpusConfig = "";
        this.segmenterName = "";
        this.c99MaskSize = 11;
        this.c99SegmentsWanted = -1;
        this.tilerSlidingWindowSize = 10;
        this.tilerStepSize = 100;
        this.sentences = null;
        this.segments = null;
        this.segmentTexts = null;
    }

    public TextSegmenterResult(String text, String corpusConfig, String segmenterName, int c99MaskSize, int c99SegmentsWanted, int tilerSlidingWindowSize, int tilerStepSize, List<List<String>> sentences, List<Integer> segments) {
        this.text = text;
        this.corpusConfig = corpusConfig;
        this.segmenterName = segmenterName;
        this.c99MaskSize = c99MaskSize;
        this.c99SegmentsWanted = c99SegmentsWanted;
        this.tilerSlidingWindowSize = tilerSlidingWindowSize;
        this.tilerStepSize = tilerStepSize;
        this.sentences = sentences;
        this.segments = segments;
        this.makeSegmentTexts();
    }

    protected void makeSegmentTexts() {
        SentenceMelder melder = new SentenceMelder();
        this.segmentTexts = ListFactory.createNewList();
        int firstSentence = 0;
        int lastSentence = 0;
        for (int i = 0; i < this.segments.size(); ++i) {
            StringBuffer sb = new StringBuffer();
            firstSentence = this.segments.get(i);
            lastSentence = i < this.segments.size() - 1 ? this.segments.get(i + 1).intValue() : this.sentences.size();
            for (int j = firstSentence; j < lastSentence; ++j) {
                List<String> sentence = this.sentences.get(j);
                String sentenceText = melder.reconstituteSentence(sentence);
                sb.append(sentenceText);
                sb.append("  ");
            }
            this.segmentTexts.add(sb.toString());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.segments.size()) {
            case 0: {
                sb.append("No segments found.\n");
                break;
            }
            case 1: {
                sb.append("1 segment found using " + this.segmenterName + ".\n");
                break;
            }
            default: {
                sb.append(this.segments.size() + " segments found using " + this.segmenterName + ".\n");
            }
        }
        if (this.segments.size() == 0) {
            return sb.toString();
        }
        sb.append("Segment\tText\n");
        SentenceMelder melder = new SentenceMelder();
        int firstSentence = 0;
        int lastSentence = 0;
        for (int i = 0; i < this.segments.size(); ++i) {
            firstSentence = this.segments.get(i);
            lastSentence = i < this.segments.size() - 1 ? this.segments.get(i + 1).intValue() : this.sentences.size();
            sb.append(i + 1 + "\t");
            for (int j = firstSentence; j < lastSentence; ++j) {
                List<String> sentence = this.sentences.get(j);
                String sentenceText = melder.reconstituteSentence(sentence);
                sb.append(sentenceText);
                sb.append("  ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

