/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.corpuslinguistics.textsegmenter.C99TextSegmenter;
import edu.northwestern.at.morphadorner.corpuslinguistics.textsegmenter.TextTilingTextSegmenter;
import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerInfo;
import edu.northwestern.at.morphadorner.server.TextSegmenterResult;
import edu.northwestern.at.utils.StringUtils;
import java.util.List;
import org.restlet.data.Form;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class TextSegmenterResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("Text segmenter resource");
        this.setDescription("Segments text using text tiling or C99 algorithm.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        return this.postResults(queryParams, this.segmentText(queryParams), "token", String.class);
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        return this.postResults(queryParams, this.segmentText(queryParams), "token", String.class);
    }

    public TextSegmenterResult segmentText(Form queryParams) {
        String text = StringUtils.safeString((String)queryParams.getFirstValue("text")).trim();
        String untaggedText = this.unTag(text);
        boolean includeInputText = queryParams.getFirstValue("includeInputText") != null;
        String corpusConfig = StringUtils.safeString((String)queryParams.getFirstValue("corpusConfig")).trim();
        MorphAdornerServerInfo adornerInfo = MorphAdornerServerData.getAdornerInfo(corpusConfig);
        String segmenterName = StringUtils.safeString((String)queryParams.getFirstValue("segmenterName")).trim();
        int c99MaskSize = TextSegmenterResource.getIntValue(StringUtils.safeString((String)queryParams.getFirstValue("c99MaskSize")).trim(), 11);
        int c99SegmentsWanted = TextSegmenterResource.getIntValue(StringUtils.safeString((String)queryParams.getFirstValue("c99SegmentsWanted")).trim(), -1);
        int tilerSlidingWindowSize = TextSegmenterResource.getIntValue(StringUtils.safeString((String)queryParams.getFirstValue("tilerSlidingWindowSize")).trim(), 10);
        int tilerStepSize = TextSegmenterResource.getIntValue(StringUtils.safeString((String)queryParams.getFirstValue("tilerStepSize")).trim(), 100);
        List sentences = null;
        List segments = null;
        if (untaggedText.length() > 0) {
            sentences = adornerInfo.sentenceSplitter.extractSentences(untaggedText);
            if (segmenterName != null) {
                C99TextSegmenter textSegmenter;
                if (segmenterName.equals("C99")) {
                    textSegmenter = new C99TextSegmenter();
                    textSegmenter.setSegmentsWanted(c99SegmentsWanted);
                    textSegmenter.setMaskSize(c99MaskSize);
                } else {
                    textSegmenter = new TextTilingTextSegmenter();
                    ((TextTilingTextSegmenter)textSegmenter).setSlidingWindowSize(tilerSlidingWindowSize);
                    ((TextTilingTextSegmenter)textSegmenter).setStepSize(tilerStepSize);
                }
                segments = textSegmenter.getSegmentPositions(sentences);
            }
        }
        return new TextSegmenterResult(includeInputText ? text : null, corpusConfig, segmenterName, c99MaskSize, c99SegmentsWanted, tilerSlidingWindowSize, tilerStepSize, sentences, segments);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        List<ParameterInfo> params = super.describeParameters();
        ParameterInfo param = new ParameterInfo("text", true, WADLSTRING, ParameterStyle.QUERY, "Text to segment.");
        params.add(param);
        param = new ParameterInfo("includeInputText", true, WADLBOOLEAN, ParameterStyle.QUERY, "Include input text in output.");
        params.add(param);
        param = new ParameterInfo("corpusConfig", true, WADLSTRING, ParameterStyle.QUERY, "Corpus configuration.");
        params.add(param);
        param = new ParameterInfo("segmenterName", true, WADLSTRING, ParameterStyle.QUERY, "Text segmenter to use.");
        params.add(param);
        param = new ParameterInfo("c99MaskSize", true, WADLINT, ParameterStyle.QUERY, "C99 mask size.");
        params.add(param);
        param = new ParameterInfo("c99SegmentsWanted", true, WADLINT, ParameterStyle.QUERY, "Number of C99 segements wanted.");
        params.add(param);
        param = new ParameterInfo("tilerSlidingWindowSize", true, WADLINT, ParameterStyle.QUERY, "Text tiling sliding window size.");
        params.add(param);
        param = new ParameterInfo("tilerStepSize", true, WADLINT, ParameterStyle.QUERY, "Text tiling step size.");
        params.add(param);
        return this.sortParams(params);
    }
}

