/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.DownloadableFileRepresentation;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.UploadedFileProcessor;
import edu.northwestern.at.morphadorner.tools.unadorn.Unadorn;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class TEIUnadornerResource
extends BaseAdornerServerResource {
    public TEIUnadornerResource() {
        this.setNegotiated(false);
    }

    protected void doInit() throws ResourceException {
        this.setName("TEI unadorner resource");
        this.setDescription("Removes token level adornments from a MorphAdorner TEI XML file.");
    }

    @Post(value="multipart:xml")
    public Representation handlePost(Representation representation) throws Exception {
        this.addCORSHeaders();
        return this.unadornTEI(representation);
    }

    public Representation unadornTEI(Representation representation) throws Exception {
        boolean resultsAsAttachedFile = true;
        UploadedFileProcessor uploader = null;
        StringRepresentation result = null;
        if (!MediaType.MULTIPART_FORM_DATA.equals((Object)representation.getMediaType(), true)) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            result = new StringRepresentation((CharSequence)"Invalid parameter format for unadorn request.");
        } else {
            try {
                uploader = new UploadedFileProcessor(this.getRequest(), "teifile", MorphAdornerServerData.getMaxAdornedUploadFileSize());
            }
            catch (Exception e) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)("Error unadorning file: " + e.getMessage()));
                return result;
            }
            resultsAsAttachedFile = TEIUnadornerResource.getBooleanValue(uploader.params.get("resultsAsAttachedFile"), false);
            if (!uploader.foundFiles) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)"No file to unadorn provided.");
            } else {
                try {
                    result = this.runUnadorner(uploader, resultsAsAttachedFile);
                }
                catch (Exception e) {
                    this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                    result = new StringRepresentation((CharSequence)"Error unadorning file.");
                }
            }
        }
        return result;
    }

    public Representation runUnadorner(UploadedFileProcessor uploader, boolean resultsAsAttachedFile) throws IOException, IllegalStateException {
        File tempDir = uploader.getTemporaryDirectory();
        String outputDir = MorphAdornerServerData.makeFileName(tempDir, "unadorned");
        uploader.addTempDirectory(tempDir.getCanonicalPath());
        uploader.addTempDirectory(outputDir);
        new File(outputDir).mkdirs();
        Unadorn.main((String[])new String[]{outputDir, uploader.getFullFileName("teifile")});
        File funadornedFile = new File(outputDir, uploader.getFileName("teifile"));
        String unadornedFileName = funadornedFile.getCanonicalPath();
        uploader.addTempFile(unadornedFileName);
        return new DownloadableFileRepresentation(unadornedFileName, uploader.getFileName("teifile"), MediaType.APPLICATION_XML, true, uploader, resultsAsAttachedFile);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        ParameterInfo param = new ParameterInfo("teifile", true, WADLSTRING, ParameterStyle.QUERY, "TEI XML file to unadorn (upload).");
        params.add(param);
        param = new ParameterInfo("resultsAsAttachedFile", true, WADLBOOLEAN, ParameterStyle.QUERY, "Return result as an attached file.");
        params.add(param);
        return this.sortParams(params);
    }
}

