/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.TEIAdornerResource;
import edu.northwestern.at.morphadorner.server.UploadedFileProcessor;
import edu.northwestern.at.morphadorner.server.logging.MorphAdornerServerLogger;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class TEITokenizerResource
extends TEIAdornerResource {
    public TEITokenizerResource() {
        this.setNegotiated(false);
    }

    @Override
    protected void doInit() throws ResourceException {
        this.setName("TEI tokenizer resource");
        this.setDescription("Tokenize a TEI XML file.");
    }

    @Override
    @Post(value="multipart:xml")
    public Representation handlePost(Representation representation) throws Exception {
        this.addCORSHeaders();
        return this.tokenizeTEI(representation);
    }

    public Representation tokenizeTEI(Representation representation) throws Exception {
        String configuration = "";
        StringRepresentation result = null;
        boolean resultsAsAttachedFile = true;
        UploadedFileProcessor uploader = null;
        if (!MediaType.MULTIPART_FORM_DATA.equals((Object)representation.getMediaType(), true)) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            result = new StringRepresentation((CharSequence)"Invalid parameter format for TEI tokenizer request.");
        } else {
            try {
                uploader = new UploadedFileProcessor(this.getRequest(), "teifile", MorphAdornerServerData.getMaxUnadornedUploadFileSize());
            }
            catch (Exception e) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)("Error unadorning file: " + e.getMessage()));
                return result;
            }
            configuration = uploader.params.get("corpusConfig");
            if (configuration.length() == 0) {
                configuration = "ncf";
            }
            resultsAsAttachedFile = TEITokenizerResource.getBooleanValue(uploader.params.get("resultsAsAttachedFile"), false);
            if (!uploader.foundFiles) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)"No file to tokenize provided.");
            } else {
                try {
                    result = this.runMorphAdorner(uploader, configuration, true, false, resultsAsAttachedFile);
                }
                catch (Exception e) {
                    MorphAdornerServerLogger.logger.log((Priority)Level.ERROR, (Object)e);
                    result = new StringRepresentation((CharSequence)("Error tokenizing file: " + e.getMessage()));
                }
            }
        }
        return result;
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        ParameterInfo param = new ParameterInfo("teifile", true, WADLSTRING, ParameterStyle.QUERY, "TEI XML file to tokenize (upload).");
        params.add(param);
        param = new ParameterInfo("corpusConfig", true, WADLSTRING, ParameterStyle.QUERY, "Corpus configuration.");
        params.add(param);
        param = new ParameterInfo("resultsAsAttachedFile", true, WADLBOOLEAN, ParameterStyle.QUERY, "Return result as an attached file.");
        params.add(param);
        return this.sortParams(params);
    }
}

