/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.DownloadableFileRepresentation;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.UploadedFileProcessor;
import edu.northwestern.at.morphadorner.tools.applyxslt.ApplyXSLT;
import edu.northwestern.at.utils.FileNameUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class TEIToTextResource
extends BaseAdornerServerResource {
    public TEIToTextResource() {
        this.setNegotiated(false);
    }

    protected void doInit() throws ResourceException {
        this.setName("TEI to text resource");
        this.setDescription("Extracts text from a TEI XML file.");
    }

    @Post(value="multipart:txt")
    public Representation handlePost(Representation representation) throws Exception {
        return this.extractTextFromTEI(representation);
    }

    public Representation extractTextFromTEI(Representation representation) throws Exception {
        String inputXML = "";
        String outputText = "";
        boolean resultsAsAttachedFile = true;
        StringRepresentation result = null;
        UploadedFileProcessor uploader = null;
        if (!MediaType.MULTIPART_FORM_DATA.equals((Object)representation.getMediaType(), true)) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            result = new StringRepresentation((CharSequence)"Invalid parameter format for unadorn request.");
        } else {
            try {
                uploader = new UploadedFileProcessor(this.getRequest(), "teifile", MorphAdornerServerData.getMaxAdornedUploadFileSize());
            }
            catch (Exception e) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)("Error unadorning file: " + e.getMessage()));
                return result;
            }
            resultsAsAttachedFile = TEIToTextResource.getBooleanValue(uploader.params.get("resultsAsAttachedFile"), false);
            if (!uploader.foundFiles) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)"No file from which to extract text provided.");
            } else {
                try {
                    result = this.runTextExtractor(uploader, resultsAsAttachedFile);
                }
                catch (Exception e) {
                    this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                    result = new StringRepresentation((CharSequence)"Unable to extract text.");
                }
            }
        }
        return result;
    }

    public Representation runTextExtractor(UploadedFileProcessor uploader, boolean resultsAsAttachedFile) throws IOException, IllegalStateException {
        String outputDir = MorphAdornerServerData.makeFileName(uploader.getTemporaryDirectory(), "teitext");
        uploader.addTempDirectory(outputDir);
        new File(outputDir).mkdirs();
        String ddir = MorphAdornerServerData.dataDirectory;
        String teiToTextXSLT = MorphAdornerServerData.makeFileName(ddir, "tei2text.xsl");
        ApplyXSLT.main((String[])new String[]{outputDir, teiToTextXSLT, uploader.getFullFileName("teifile")});
        File fOutputFile = new File(outputDir, uploader.getFileName("teifile"));
        String outputFileName = fOutputFile.getCanonicalPath();
        uploader.addTempFile(outputFileName);
        String contentFileName = FileNameUtils.changeFileExtension((String)outputFileName, (String)".txt");
        contentFileName = FileNameUtils.stripPathName((String)contentFileName);
        DownloadableFileRepresentation result = new DownloadableFileRepresentation(outputFileName, contentFileName, MediaType.TEXT_PLAIN, true, uploader, resultsAsAttachedFile);
        return result;
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        ParameterInfo param = new ParameterInfo("teifile", true, WADLSTRING, ParameterStyle.QUERY, "TEI XML file from which to extract text (upload).");
        params.add(param);
        param = new ParameterInfo("resultsAsAttachedFile", true, WADLBOOLEAN, ParameterStyle.QUERY, "Return result as an attached file.");
        params.add(param);
        return this.sortParams(params);
    }
}

