/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.DownloadableFileRepresentation;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.UploadedFileProcessor;
import edu.northwestern.at.morphadorner.tools.applyxslt.ApplyXSLT;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class TEINotesMoverResource
extends BaseAdornerServerResource {
    public TEINotesMoverResource() {
        this.setNegotiated(false);
    }

    protected void doInit() throws ResourceException {
        this.setName("TEI notes mover resource");
        this.setDescription("Moves TEI notes to div at end of TEI XML file.");
    }

    @Post(value="multipart:xml")
    public Representation handlePost(Representation representation) throws Exception {
        this.addCORSHeaders();
        return this.moveTEINotes(representation);
    }

    public Representation moveTEINotes(Representation representation) throws Exception {
        StringRepresentation result = null;
        UploadedFileProcessor uploader = null;
        boolean resultsAsAttachedFile = true;
        if (!MediaType.MULTIPART_FORM_DATA.equals((Object)representation.getMediaType(), true)) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            result = new StringRepresentation((CharSequence)"Invalid parameter format for notes mover request.");
        } else {
            try {
                uploader = new UploadedFileProcessor(this.getRequest(), "teifile", MorphAdornerServerData.getMaxAdornedUploadFileSize());
            }
            catch (Exception e) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)("Error unadorning file: " + e.getMessage()));
                return result;
            }
            resultsAsAttachedFile = TEINotesMoverResource.getBooleanValue(uploader.params.get("resultsAsAttachedFile"), false);
            if (!uploader.foundFiles) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)"No file in which to move notes provided.");
            } else {
                try {
                    result = this.runNotesMover(uploader, resultsAsAttachedFile);
                }
                catch (Exception e) {
                    this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                }
            }
        }
        return result;
    }

    public Representation runNotesMover(UploadedFileProcessor uploader, boolean resultsAsAttachedFile) throws IOException, IllegalStateException {
        String outputDir = MorphAdornerServerData.makeFileName(uploader.getTemporaryDirectory(), "notesmoved");
        uploader.addTempDirectory(outputDir);
        new File(outputDir).mkdirs();
        String ddir = MorphAdornerServerData.dataDirectory;
        String notesMoverXSLT = MorphAdornerServerData.makeFileName(ddir, "movenotes.xsl");
        ApplyXSLT.main((String[])new String[]{outputDir, notesMoverXSLT, uploader.getFullFileName("teifile")});
        File fOutputFile = new File(outputDir, uploader.getFileName("teifile"));
        String outputFileName = fOutputFile.getCanonicalPath();
        uploader.addTempFile(outputFileName);
        DownloadableFileRepresentation result = new DownloadableFileRepresentation(outputFileName, uploader.getFileName("teifile"), MediaType.APPLICATION_XML, true, uploader, resultsAsAttachedFile);
        return result;
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        ParameterInfo param = new ParameterInfo("teifile", true, WADLSTRING, ParameterStyle.QUERY, "TEI XML file in which to move notes (upload).");
        params.add(param);
        param = new ParameterInfo("resultsAsAttachedFile", true, WADLBOOLEAN, ParameterStyle.QUERY, "Return result as an attached file.");
        params.add(param);
        return this.sortParams(params);
    }
}

