/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.DownloadableFileRepresentation;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.UploadedFileProcessor;
import edu.northwestern.at.morphadorner.tools.compareadornedfiles.CompareAdornedFiles;
import edu.northwestern.at.utils.NullOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class TEICompareAdornedFilesResource
extends BaseAdornerServerResource {
    public TEICompareAdornedFilesResource() {
        this.setNegotiated(false);
    }

    protected void doInit() throws ResourceException {
        this.setName("TEI compare adorned files resource");
        this.setDescription("Compares two versions of an adorned file and generates a token-level change file.");
    }

    @Post(value="multipart:xml")
    public Representation handlePost(Representation representation) throws Exception {
        this.addCORSHeaders();
        return this.compareAdornedFiles(representation);
    }

    public Representation compareAdornedFiles(Representation representation) throws Exception {
        boolean resultsAsAttachedFile = true;
        UploadedFileProcessor uploader = null;
        StringRepresentation result = null;
        if (!MediaType.MULTIPART_FORM_DATA.equals((Object)representation.getMediaType(), true)) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            result = new StringRepresentation((CharSequence)"Invalid parameter format for compare files request.");
        } else {
            try {
                uploader = new UploadedFileProcessor(this.getRequest(), new String[]{"origadornedfile", "updatedadornedfile"}, MorphAdornerServerData.getMaxAdornedUploadFileSize());
            }
            catch (Exception e) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)("Error unadorning file: " + e.getMessage()));
                return result;
            }
            resultsAsAttachedFile = TEICompareAdornedFilesResource.getBooleanValue(uploader.params.get("resultsAsAttachedFile"), false);
            if (!uploader.foundFiles) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)"Files to compare not provided.");
            } else {
                try {
                    result = this.runComparer(uploader, resultsAsAttachedFile);
                }
                catch (Exception e) {
                    this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                    result = new StringRepresentation((CharSequence)"Error comparing files.");
                }
            }
        }
        return result;
    }

    public Representation runComparer(UploadedFileProcessor uploader, boolean resultsAsAttachedFile) throws Exception {
        String outputDir = MorphAdornerServerData.makeFileName(uploader.getTemporaryDirectory(), "changelogdir");
        uploader.addTempDirectory(outputDir);
        File fChangeLogFile = new File(outputDir, "changelog.xml");
        String changeLogFileName = fChangeLogFile.getCanonicalPath();
        uploader.addTempFile(changeLogFileName);
        new File(outputDir).mkdirs();
        new CompareAdornedFiles(uploader.getFullFileName("origadornedfile"), uploader.getFullFileName("updatedadornedfile"), changeLogFileName, new PrintStream((OutputStream)new NullOutputStream()));
        return new DownloadableFileRepresentation(changeLogFileName, "changelog.xml", MediaType.APPLICATION_XML, true, uploader, resultsAsAttachedFile);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        ParameterInfo param = new ParameterInfo("origadornedfile", true, WADLSTRING, ParameterStyle.QUERY, "Original adorned TEI XML file (upload).");
        params.add(param);
        param = new ParameterInfo("updatedadornedfile", true, WADLSTRING, ParameterStyle.QUERY, "Updated adorned TEI XML file (upload).");
        params.add(param);
        param = new ParameterInfo("resultsAsAttachedFile", true, WADLBOOLEAN, ParameterStyle.QUERY, "Return result as an attached file.");
        params.add(param);
        return this.sortParams(params);
    }
}

