/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.DownloadableFileRepresentation;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.UploadedFileProcessor;
import edu.northwestern.at.morphadorner.tools.compareadornedfiles.UpdateAdornedFile;
import edu.northwestern.at.utils.NullOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class TEIApplyChangesToAdornedFileResource
extends BaseAdornerServerResource {
    public TEIApplyChangesToAdornedFileResource() {
        this.setNegotiated(false);
    }

    protected void doInit() throws ResourceException {
        this.setName("TEI apply changes to an adorned file resource");
        this.setDescription("Applies changes specified in a change log file to a tokenized or adorned TEI XML file.");
    }

    @Post(value="multipart:xml")
    public Representation handlePost(Representation representation) throws Exception {
        this.addCORSHeaders();
        return this.applyChanges(representation);
    }

    public Representation applyChanges(Representation representation) throws Exception {
        boolean resultsAsAttachedFile = true;
        boolean revertChanges = false;
        UploadedFileProcessor uploader = null;
        StringRepresentation result = null;
        if (!MediaType.MULTIPART_FORM_DATA.equals((Object)representation.getMediaType(), true)) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            result = new StringRepresentation((CharSequence)"Invalid parameter format for apply changes request.");
        } else {
            try {
                uploader = new UploadedFileProcessor(this.getRequest(), new String[]{"origadornedfile", "changelogfile"}, MorphAdornerServerData.getMaxAdornedUploadFileSize());
            }
            catch (Exception e) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)("Error unadorning file: " + e.getMessage()));
                return result;
            }
            resultsAsAttachedFile = TEIApplyChangesToAdornedFileResource.getBooleanValue(uploader.params.get("resultsAsAttachedFile"), false);
            boolean bl = revertChanges = uploader.params.get("revertChanges") != null;
            if (!uploader.foundFiles) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)"Files needed to apply changes not provided.");
            } else {
                try {
                    result = this.runChanger(uploader, resultsAsAttachedFile, revertChanges);
                }
                catch (Exception e) {
                    this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                    result = new StringRepresentation((CharSequence)"Error applying changes.");
                }
            }
        }
        return result;
    }

    public Representation runChanger(UploadedFileProcessor uploader, boolean resultsAsAttachedFile, boolean revertChanges) throws Exception {
        String outputDir = MorphAdornerServerData.makeFileName(uploader.getTemporaryDirectory(), "updatedadornedfiledir");
        uploader.addTempDirectory(outputDir);
        File fUpdatedAdornedFileName = new File(outputDir, uploader.getFileName("origadornedfile"));
        String updatedAdornedFileName = fUpdatedAdornedFileName.getCanonicalPath();
        uploader.addTempFile(updatedAdornedFileName);
        new File(outputDir).mkdirs();
        new UpdateAdornedFile(revertChanges, uploader.getFullFileName("origadornedfile"), uploader.getFullFileName("changelogfile"), updatedAdornedFileName, new PrintStream((OutputStream)new NullOutputStream()));
        return new DownloadableFileRepresentation(updatedAdornedFileName, uploader.getFileName("origadornedfile"), MediaType.APPLICATION_XML, true, uploader, resultsAsAttachedFile);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        ParameterInfo param = new ParameterInfo("origadornedfile", true, WADLSTRING, ParameterStyle.QUERY, "Original adorned TEI XML file (upload).");
        params.add(param);
        param = new ParameterInfo("changelogfile", true, WADLSTRING, ParameterStyle.QUERY, "XML change log file (upload).");
        params.add(param);
        param = new ParameterInfo("resultsAsAttachedFile", true, WADLBOOLEAN, ParameterStyle.QUERY, "Return result as an attached file.");
        params.add(param);
        param = new ParameterInfo("revertChanges", true, WADLBOOLEAN, ParameterStyle.QUERY, "Revert changes.");
        params.add(param);
        return this.sortParams(params);
    }
}

