/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.MorphAdorner;
import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.DownloadableFileRepresentation;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.UploadedFileProcessor;
import edu.northwestern.at.morphadorner.server.logging.MorphAdornerServerLogger;
import edu.northwestern.at.morphadorner.tools.adornedtosimpleteip5.AdornedToSimpleTEIP5;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class TEIAdornerResource
extends BaseAdornerServerResource {
    public TEIAdornerResource() {
        this.setNegotiated(false);
    }

    protected void doInit() throws ResourceException {
        this.setName("TEI adorner resource");
        this.setDescription("Add morphological adornments to a TEI XML text.");
    }

    @Post(value="multipart:xml")
    public Representation handlePost(Representation representation) throws Exception {
        this.addCORSHeaders();
        return this.adornTEI(representation);
    }

    public Representation adornTEI(Representation representation) throws Exception {
        String configuration = "";
        StringRepresentation result = null;
        boolean resultsAsAttachedFile = true;
        boolean useChoiceForReg = false;
        UploadedFileProcessor uploader = null;
        if (!MediaType.MULTIPART_FORM_DATA.equals((Object)representation.getMediaType(), true)) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            result = new StringRepresentation((CharSequence)"Invalid parameter format for TEI adorner request.");
        } else {
            try {
                uploader = new UploadedFileProcessor(this.getRequest(), "teifile", MorphAdornerServerData.getMaxUnadornedUploadFileSize());
            }
            catch (Exception e) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)("Error unadorning file: " + e.getMessage()));
                return result;
            }
            configuration = uploader.params.get("corpusConfig");
            if (configuration.length() == 0) {
                configuration = "ncf";
            }
            resultsAsAttachedFile = TEIAdornerResource.getBooleanValue(uploader.params.get("resultsAsAttachedFile"), false);
            useChoiceForReg = TEIAdornerResource.getBooleanValue(uploader.params.get("useChoice"), false);
            if (!uploader.foundFiles) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)"No file to adorn provided.");
            } else {
                try {
                    result = this.runMorphAdorner(uploader, configuration, false, useChoiceForReg, resultsAsAttachedFile);
                }
                catch (Exception e) {
                    MorphAdornerServerLogger.logger.log((Priority)Level.ERROR, (Object)e);
                    result = new StringRepresentation((CharSequence)("Error adorning file: " + e.getMessage()));
                }
            }
        }
        return result;
    }

    public Representation runMorphAdorner(UploadedFileProcessor uploader, String configuration, boolean tokenizeOnly, boolean useChoiceForReg, boolean resultsAsAttachedFile) throws IOException, IllegalStateException {
        ArrayList<String> morphArgs = new ArrayList<String>();
        String ddir = MorphAdornerServerData.dataDirectory;
        morphArgs.add("-p");
        morphArgs.add(MorphAdornerServerData.makeFileName(ddir, configuration + ".properties"));
        morphArgs.add("-d");
        morphArgs.add(MorphAdornerServerData.makeFileName(ddir, "morphadorner.properties"));
        String outputDir = MorphAdornerServerData.makeFileName(uploader.getTemporaryDirectory(), "adorned");
        String tempOutputDir = MorphAdornerServerData.makeFileName(uploader.getTemporaryDirectory(), "tempAdorned");
        uploader.addTempDirectory(outputDir);
        uploader.addTempDirectory(tempOutputDir);
        String[] morphArgsArray = morphArgs.toArray(new String[morphArgs.size()]);
        String logConfig = MorphAdornerServerData.makeFileName(ddir, "morphadornerlog.config");
        String logDir = MorphAdornerServerData.makeFileName(uploader.getTemporaryDirectory(), "log");
        uploader.addTempDirectory(logDir);
        MorphAdorner.createAndRunAdorner((String)configuration, (boolean)false, (String[])morphArgsArray, (String)logConfig, (String)logDir, (String)tempOutputDir, (String[])new String[]{uploader.getFullFileName("teifile")}, (boolean)tokenizeOnly);
        String adornedFileName = "";
        if (tokenizeOnly) {
            File fTempOutputDir = new File(tempOutputDir);
            File fTokenizedFile = new File(fTempOutputDir, uploader.getFileName("teifile"));
            adornedFileName = fTokenizedFile.getCanonicalPath();
        } else {
            ArrayList<String> args = new ArrayList<String>();
            args.add(outputDir);
            args.add(useChoiceForReg ? "usechoice" : "usereg");
            args.add(MorphAdornerServerData.makeFileName(ddir, "interpgrp.xml"));
            args.add(MorphAdornerServerData.makeFileName(tempOutputDir, "goodfiles.txt"));
            args.add(MorphAdornerServerData.makeFileName(tempOutputDir, "badfiles.txt"));
            args.add(MorphAdornerServerData.makeFileName(tempOutputDir, uploader.getFileName("teifile")));
            String[] argsArray = args.toArray(new String[args.size()]);
            AdornedToSimpleTEIP5.main((String[])argsArray);
            File fOutputDir = new File(outputDir);
            File fAdornedFile = new File(fOutputDir, uploader.getFileName("teifile"));
            adornedFileName = fAdornedFile.getCanonicalPath();
        }
        return new DownloadableFileRepresentation(adornedFileName, uploader.getFileName("teifile"), MediaType.APPLICATION_XML, true, uploader, resultsAsAttachedFile);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        ParameterInfo param = new ParameterInfo("teifile", true, WADLSTRING, ParameterStyle.QUERY, "TEI XML file to adorn (upload).");
        params.add(param);
        param = new ParameterInfo("corpusConfig", true, WADLSTRING, ParameterStyle.QUERY, "Corpus configuration.");
        params.add(param);
        param = new ParameterInfo("resultsAsAttachedFile", true, WADLBOOLEAN, ParameterStyle.QUERY, "Return result as an attached file.");
        params.add(param);
        param = new ParameterInfo("useChoice", true, WADLBOOLEAN, ParameterStyle.QUERY, "Use choice structure to emit standard spelling.");
        params.add(param);
        return this.sortParams(params);
    }
}

