/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.DownloadableFileRepresentation;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.UploadedFileProcessor;
import edu.northwestern.at.morphadorner.tools.xmltotab.XMLToTab;
import edu.northwestern.at.utils.FileNameUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class TEIAdornedToTabularFileResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("TEI adorned to tabular file resource");
        this.setDescription("Convert TEI adorned XML to tabular file format.");
    }

    @Post(value="multipart:txt")
    public Representation handlePost(Representation representation) throws Exception {
        return this.adornedTEIToTabularFormat(representation);
    }

    public Representation adornedTEIToTabularFormat(Representation representation) throws Exception {
        String adorned = "";
        String unadorned = "";
        UploadedFileProcessor uploader = null;
        boolean resultsAsAttachedFile = true;
        StringRepresentation result = null;
        if (!MediaType.MULTIPART_FORM_DATA.equals((Object)representation.getMediaType(), true)) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            result = new StringRepresentation((CharSequence)"Invalid parameter format for tabular conversion request.");
        } else {
            try {
                uploader = new UploadedFileProcessor(this.getRequest(), "teifile", MorphAdornerServerData.getMaxAdornedUploadFileSize());
            }
            catch (Exception e) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)("Error unadorning file: " + e.getMessage()));
                return result;
            }
            resultsAsAttachedFile = TEIAdornedToTabularFileResource.getBooleanValue(uploader.params.get("resultsAsAttachedFile"), false);
            if (!uploader.foundFiles) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)"No file provided to convert to tabular format.");
            } else {
                try {
                    result = this.teiToTabularFile(uploader, resultsAsAttachedFile);
                }
                catch (Exception e) {
                    this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                    result = new StringRepresentation((CharSequence)"Error converting TEI XML to tabular format.");
                }
            }
        }
        return result;
    }

    public Representation teiToTabularFile(UploadedFileProcessor uploader, boolean resultsAsAttachedFile) throws IOException, IllegalStateException {
        String outputDir = MorphAdornerServerData.makeFileName(uploader.getTemporaryDirectory(), "tabular");
        uploader.addTempDirectory(outputDir);
        String shortTabularFileName = FileNameUtils.changeFileExtension((String)uploader.getFileName("teifile"), (String)".tab");
        File fTabularFile = new File(outputDir, shortTabularFileName);
        String tabularFileName = fTabularFile.getCanonicalPath();
        uploader.addTempFile(tabularFileName);
        new File(outputDir).mkdirs();
        XMLToTab.main((String[])new String[]{uploader.getFullFileName("teifile"), tabularFileName});
        return new DownloadableFileRepresentation(tabularFileName, shortTabularFileName, MediaType.TEXT_PLAIN, true, uploader, resultsAsAttachedFile);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        ParameterInfo param = new ParameterInfo("teifile", true, WADLSTRING, ParameterStyle.QUERY, "TEI XML file to convert to tabular format (upload).");
        params.add(param);
        param = new ParameterInfo("resultsAsAttachedFile", true, WADLBOOLEAN, ParameterStyle.QUERY, "Return result as an attached file.");
        params.add(param);
        return this.sortParams(params);
    }
}

