/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.corpuslinguistics.sentencemelder.SentenceMelder;
import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.DownloadableFileRepresentation;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.UploadedFileProcessor;
import edu.northwestern.at.morphadorner.tools.AdornedXMLReader;
import edu.northwestern.at.morphadorner.tools.ExtendedAdornedWord;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.ListFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;
import org.xml.sax.SAXException;

public class TEIAdornedToSentencesResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("TEI adorned to sentences resource");
        this.setDescription("Extract sentences from an adorned TEI XML file.");
    }

    @Post(value="multipart:txt")
    public Representation handlePost(Representation representation) throws Exception {
        return this.extractSentencesFromAdornedTEI(representation);
    }

    public Representation extractSentencesFromAdornedTEI(Representation representation) throws Exception {
        UploadedFileProcessor uploader = null;
        boolean resultsAsAttachedFile = true;
        StringRepresentation result = null;
        boolean mainTextOnly = false;
        if (!MediaType.MULTIPART_FORM_DATA.equals((Object)representation.getMediaType(), true)) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            result = new StringRepresentation((CharSequence)"Invalid parameter format for sentence extraction request.");
        } else {
            try {
                uploader = new UploadedFileProcessor(this.getRequest(), "teifile", MorphAdornerServerData.getMaxAdornedUploadFileSize());
            }
            catch (Exception e) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)("Error unadorning file: " + e.getMessage()));
                return result;
            }
            resultsAsAttachedFile = TEIAdornedToSentencesResource.getBooleanValue(uploader.params.get("resultsAsAttachedFile"), false);
            mainTextOnly = TEIAdornedToSentencesResource.getBooleanValue(uploader.params.get("mainTextOnly"), false);
            if (!uploader.foundFiles) {
                this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                result = new StringRepresentation((CharSequence)"No file from which to extract sentences provided.");
            } else {
                try {
                    result = this.extractSentencesFromAdornedTEI(uploader, resultsAsAttachedFile, mainTextOnly);
                }
                catch (Exception e) {
                    this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                    result = new StringRepresentation((CharSequence)"Error extracting sentences.");
                }
            }
        }
        return result;
    }

    public Representation extractSentencesFromAdornedTEI(UploadedFileProcessor uploader, boolean resultsAsAttachedFile, boolean mainTextOnly) throws IOException, IllegalStateException, SAXException {
        String outputDir = MorphAdornerServerData.makeFileName(uploader.getTemporaryDirectory(), "unadorned");
        uploader.addTempDirectory(outputDir);
        new File(outputDir).mkdirs();
        AdornedXMLReader xmlReader = new AdornedXMLReader(uploader.getFullFileName("teifile"));
        List sentences = xmlReader.getSentences();
        SentenceMelder melder = new SentenceMelder();
        String shortSentencesFileName = FileNameUtils.changeFileExtension((String)uploader.getFileName("teifile"), (String)".txt");
        File fSentencesFile = new File(outputDir, shortSentencesFileName);
        String sentencesFileName = fSentencesFile.getCanonicalPath();
        uploader.addTempFile(sentencesFileName);
        PrintStream printStream = new PrintStream(fSentencesFile, "utf-8");
        boolean ok = false;
        for (int i = 0; i < sentences.size(); ++i) {
            List<ExtendedAdornedWord> sentence = (List<ExtendedAdornedWord>)sentences.get(i);
            ok = true;
            if (mainTextOnly) {
                boolean bl = ok = (sentence = this.ejectParatext(sentence)).size() > 0;
            }
            if (!ok) continue;
            printStream.println(melder.reconstituteSentence(sentence));
        }
        printStream.close();
        return new DownloadableFileRepresentation(sentencesFileName, shortSentencesFileName, MediaType.TEXT_PLAIN, true, uploader, resultsAsAttachedFile);
    }

    public List<ExtendedAdornedWord> ejectParatext(List<ExtendedAdornedWord> sentence) {
        List result = ListFactory.createNewList();
        for (ExtendedAdornedWord adornedWord : sentence) {
            if (adornedWord.getMainSide() != ExtendedAdornedWord.MainSide.MAIN) continue;
            result.add(adornedWord);
        }
        return result;
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        ParameterInfo param = new ParameterInfo("teifile", true, WADLSTRING, ParameterStyle.QUERY, "TEI XML file from which to extract sentences (upload).");
        params.add(param);
        param = new ParameterInfo("resultsAsAttachedFile", true, WADLBOOLEAN, ParameterStyle.QUERY, "Return result as an attached file.");
        params.add(param);
        return this.sortParams(params);
    }
}

