/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.SyllableCounterResult;
import edu.northwestern.at.utils.StringUtils;
import java.util.List;
import org.restlet.data.Form;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class SyllableCounterResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("Syllable counter resource");
        this.setDescription("Counts syllables in a word.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        return this.postResults(queryParams, this.countSyllables(queryParams));
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        return this.postResults(queryParams, this.countSyllables(queryParams));
    }

    public SyllableCounterResult countSyllables(Form queryParams) {
        String spelling = StringUtils.safeString((String)queryParams.getFirstValue("spelling")).trim();
        int syllableCount = 0;
        if (spelling.length() > 0) {
            syllableCount = MorphAdornerServerData.syllableCounter.countSyllables(spelling);
        }
        return new SyllableCounterResult(spelling, syllableCount);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        List<ParameterInfo> params = super.describeParameters();
        ParameterInfo param = new ParameterInfo("spelling", true, WADLSTRING, ParameterStyle.QUERY, "Spelling to syllabify.");
        params.add(param);
        return this.sortParams(params);
    }
}

