/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.corpuslinguistics.sentencemelder.SentenceMelder;
import edu.northwestern.at.morphadorner.corpuslinguistics.textsummarizer.DefaultTextSummarizer;
import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerInfo;
import edu.northwestern.at.morphadorner.server.SummarizerResult;
import edu.northwestern.at.utils.StringUtils;
import java.util.List;
import org.restlet.data.Form;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class SummarizerResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("Summarizer resource");
        this.setDescription("Finds short summary for a text.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        return this.postResults(queryParams, this.summarize(queryParams));
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        return this.postResults(queryParams, this.summarize(queryParams));
    }

    public SummarizerResult summarize(Form queryParams) {
        String text = StringUtils.safeString((String)queryParams.getFirstValue("text")).trim();
        text = this.unTag(text);
        boolean includeInputText = queryParams.getFirstValue("includeInputText") != null;
        String corpusConfig = StringUtils.safeString((String)queryParams.getFirstValue("corpusConfig")).trim();
        MorphAdornerServerInfo adornerInfo = MorphAdornerServerData.getAdornerInfo(corpusConfig);
        String sMaxSumSent = StringUtils.safeString((String)queryParams.getFirstValue("maxSumSent")).trim();
        int maxSumSent = 0;
        try {
            maxSumSent = Integer.parseInt(sMaxSumSent);
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuffer summaryText = null;
        if (text.length() > 0) {
            List sentences = adornerInfo.sentenceSplitter.extractSentences(text);
            int nSentences = maxSumSent;
            if (nSentences < 2) {
                nSentences = Math.min(sentences.size(), 2);
            }
            DefaultTextSummarizer summarizer = new DefaultTextSummarizer();
            List summarySentences = summarizer.summarize(sentences, nSentences);
            SentenceMelder melder = new SentenceMelder();
            summaryText = new StringBuffer();
            for (int i = 0; i < summarySentences.size(); ++i) {
                List sentence = (List)sentences.get((Integer)summarySentences.get(i));
                String sentenceText = melder.reconstituteSentence(sentence);
                summaryText.append(sentenceText);
                summaryText.append(" ");
                melder.reset();
            }
        }
        return new SummarizerResult(includeInputText ? text : null, corpusConfig, maxSumSent, summaryText.toString());
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        List<ParameterInfo> params = super.describeParameters();
        ParameterInfo param = new ParameterInfo("text", true, WADLSTRING, ParameterStyle.QUERY, "Text to summarize.");
        params.add(param);
        param = new ParameterInfo("includeInputText", true, WADLBOOLEAN, ParameterStyle.QUERY, "Include input text in output.");
        params.add(param);
        param = new ParameterInfo("corpusConfig", true, WADLSTRING, ParameterStyle.QUERY, "Corpus configuration.");
        params.add(param);
        param = new ParameterInfo("maxSumSent", true, WADLINT, ParameterStyle.QUERY, "Maximum number of summary sentences.");
        params.add(param);
        return this.sortParams(params);
    }
}

