/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer.EnglishDecruftifier;
import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerInfo;
import edu.northwestern.at.morphadorner.server.SpellingStandardizerResult;
import edu.northwestern.at.utils.ScoredString;
import edu.northwestern.at.utils.SortedArrayList;
import edu.northwestern.at.utils.StringUtils;
import java.util.Collection;
import java.util.List;
import org.restlet.data.Form;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class SpellingStandardizerResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("Spelling standardizer resource");
        this.setDescription("Finds standard spelling for a variant spelling.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        return this.postResults(queryParams, this.standardizeSpelling(queryParams));
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        return this.postResults(queryParams, this.standardizeSpelling(queryParams));
    }

    public SpellingStandardizerResult standardizeSpelling(Form queryParams) {
        String spelling = StringUtils.safeString((String)queryParams.getFirstValue("spelling")).trim();
        String corpusConfig = StringUtils.safeString((String)queryParams.getFirstValue("corpusConfig")).trim();
        String wordClass = StringUtils.safeString((String)queryParams.getFirstValue("wordClass")).trim();
        String wordClass2 = StringUtils.safeString((String)queryParams.getFirstValue("wordClass2")).trim();
        String sExtendedSearch = StringUtils.safeString((String)queryParams.getFirstValue("extendedSearch")).trim();
        boolean extendedSearch = sExtendedSearch.equals("true") || sExtendedSearch.equals("1");
        MorphAdornerServerInfo adornerInfo = MorphAdornerServerData.getAdornerInfo(corpusConfig);
        String suggestion = spelling;
        SortedArrayList suggestions = null;
        if (spelling.length() > 0) {
            if (extendedSearch) {
                System.out.println("standardizer: spelling=" + spelling);
                System.out.println("standardizer: decrutified spelling=" + EnglishDecruftifier.decruftify((String)spelling));
                suggestions = new SortedArrayList((Collection)adornerInfo.standardizer.getScoredSuggestedSpellings(EnglishDecruftifier.decruftify((String)spelling)));
                suggestion = ((ScoredString)suggestions.get(suggestions.size() - 1)).getString();
                if (suggestion.equals("?")) {
                    suggestion = adornerInfo.adorner.spellingStandardizer.standardizeSpelling(spelling, "");
                }
            } else {
                suggestions = null;
                suggestion = adornerInfo.simpleStandardizer.standardizeSpelling(spelling, "");
            }
        }
        return new SpellingStandardizerResult(spelling, suggestion, corpusConfig, wordClass, wordClass2);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        List<ParameterInfo> params = super.describeParameters();
        ParameterInfo param = new ParameterInfo("spelling", true, WADLSTRING, ParameterStyle.QUERY, "Spelling to standardize.");
        params.add(param);
        param = new ParameterInfo("corpusConfig", true, WADLSTRING, ParameterStyle.QUERY, "Corpus configuration.");
        params.add(param);
        param = new ParameterInfo("wordClass", true, WADLSTRING, ParameterStyle.QUERY, "Primary word class of spelling.");
        params.add(param);
        param = new ParameterInfo("wordClass2", true, WADLSTRING, ParameterStyle.QUERY, "Secondary word class of spelling.");
        params.add(param);
        param = new ParameterInfo("extendedSearch", true, WADLBOOLEAN, ParameterStyle.QUERY, "Perform extended search for standard spelling.");
        params.add(param);
        return this.sortParams(params);
    }
}

