/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import edu.northwestern.at.morphadorner.server.WordTokenizerResult;
import edu.northwestern.at.morphadorner.server.converters.MeldedSentencesListConverter;
import edu.northwestern.at.utils.Formatters;
import java.util.List;

@XStreamAlias(value="SentenceSplitterResult")
public class SentenceSplitterResult
extends WordTokenizerResult {
    @XStreamConverter(value=MeldedSentencesListConverter.class)
    public List<String> meldedSentences;

    public SentenceSplitterResult() {
        this.text = "";
        this.corpusConfig = "";
        this.langCode = "";
        this.sentences = null;
        this.meldedSentences = null;
    }

    public SentenceSplitterResult(String text, String corpusConfig, String langCode, List<List<String>> sentences, List<String> meldedSentences) {
        this.text = text;
        this.corpusConfig = corpusConfig;
        this.langCode = langCode;
        this.sentences = sentences;
        this.meldedSentences = meldedSentences;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        int nSent = this.meldedSentences.size();
        switch (nSent) {
            case 0: {
                sb.append("No sentences found.\n");
                break;
            }
            case 1: {
                sb.append("1 sentence found.\n");
                break;
            }
            default: {
                sb.append(Formatters.formatIntegerWithCommas((int)nSent) + " sentences found.\n");
            }
        }
        sb.append("S#\tSentence\n");
        for (int i = 0; i < this.meldedSentences.size(); ++i) {
            String sentence = this.meldedSentences.get(i);
            sb.append(i + 1 + "\t");
            sb.append(sentence);
            sb.append("\n");
        }
        return sb.toString();
    }
}

