/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.corpuslinguistics.sentencemelder.SentenceMelder;
import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerInfo;
import edu.northwestern.at.morphadorner.server.SentenceSplitterResult;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.StringUtils;
import java.util.List;
import org.restlet.data.Form;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class SentenceSplitterResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("Sentence splitter resource");
        this.setDescription("Splits text into sentences.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        return this.postResults(queryParams, this.splitIntoSentences(queryParams), "token", String.class);
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        return this.postResults(queryParams, this.splitIntoSentences(queryParams), "token", String.class);
    }

    public SentenceSplitterResult splitIntoSentences(Form queryParams) {
        String text = StringUtils.safeString((String)queryParams.getFirstValue("text")).trim();
        text = this.unTag(text);
        boolean includeInputText = queryParams.getFirstValue("includeInputText") != null;
        String corpusConfig = StringUtils.safeString((String)queryParams.getFirstValue("corpusConfig")).trim();
        String langCode = StringUtils.safeString((String)queryParams.getFirstValue("langCode")).trim();
        if (langCode.length() == 0) {
            langCode = this.recognizeLanguage(text);
        }
        MorphAdornerServerInfo adornerInfo = MorphAdornerServerData.getAdornerInfo(corpusConfig);
        List<List<String>> sentences = null;
        List meldedSentences = null;
        if (text.length() > 0 && langCode.length() > 0) {
            sentences = this.extractSentences(text, langCode, corpusConfig);
            SentenceMelder melder = new SentenceMelder();
            meldedSentences = ListFactory.createNewList();
            for (int i = 0; i < sentences.size(); ++i) {
                meldedSentences.add(melder.reconstituteSentence(sentences.get(i)));
            }
        }
        return new SentenceSplitterResult(includeInputText ? text : null, corpusConfig, langCode, sentences, meldedSentences);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        List<ParameterInfo> params = super.describeParameters();
        ParameterInfo param = new ParameterInfo("text", true, WADLSTRING, ParameterStyle.QUERY, "Text to split into sentences.");
        params.add(param);
        param = new ParameterInfo("includeInputText", true, WADLBOOLEAN, ParameterStyle.QUERY, "Include input text in output.");
        params.add(param);
        param = new ParameterInfo("corpusConfig", true, WADLSTRING, ParameterStyle.QUERY, "Corpus configuration.");
        params.add(param);
        param = new ParameterInfo("langCode", true, WADLSTRING, ParameterStyle.QUERY, "ISO language code for text.");
        params.add(param);
        return this.sortParams(params);
    }
}

