/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.PluralizerResult;
import edu.northwestern.at.utils.StringUtils;
import java.util.List;
import org.restlet.data.Form;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class PluralizerResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("Pluralizer resource");
        this.setDescription("Finds plural forms of nouns and pronouns.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        return this.postResults(queryParams, this.pluralize(queryParams));
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        return this.postResults(queryParams, this.pluralize(queryParams));
    }

    public PluralizerResult pluralize(Form queryParams) {
        String singular = StringUtils.safeString((String)queryParams.getFirstValue("singular")).trim();
        String sAmerican = StringUtils.safeString((String)queryParams.getFirstValue("american")).trim();
        boolean american = sAmerican.equals("1") || sAmerican.equals("true");
        String plural = singular;
        if (singular.length() > 0) {
            plural = MorphAdornerServerData.inflector.pluralize(singular);
        }
        if (american) {
            singular = MorphAdornerServerData.britishToUS.mapSpelling(singular);
            plural = MorphAdornerServerData.britishToUS.mapSpelling(plural);
        }
        return new PluralizerResult(singular, plural, american);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        List<ParameterInfo> params = super.describeParameters();
        ParameterInfo param = new ParameterInfo("singular", true, WADLSTRING, ParameterStyle.QUERY, "Singular noun or pronoun.");
        params.add(param);
        param = new ParameterInfo("american", true, WADLBOOLEAN, ParameterStyle.QUERY, "Use American spelling.");
        params.add(param);
        return this.sortParams(params);
    }
}

