/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import de.tuebingen.uni.sfs.dspin.tcf04.data.Lemma;
import de.tuebingen.uni.sfs.dspin.tcf04.data.Sentence;
import de.tuebingen.uni.sfs.dspin.tcf04.data.Tag;
import de.tuebingen.uni.sfs.dspin.tcf04.data.TextCorpusData;
import de.tuebingen.uni.sfs.dspin.tcf04.data.TextCorpusFactory;
import de.tuebingen.uni.sfs.dspin.tcf04.data.TextCorpusFormatException;
import de.tuebingen.uni.sfs.dspin.tcf04.data.TextCorpusLayerTag;
import de.tuebingen.uni.sfs.dspin.tcf04.data.Token;
import edu.northwestern.at.morphadorner.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.morphadorner.server.MyXMLSentenceMelder;
import edu.northwestern.at.morphadorner.server.WordTokenizerResult;
import edu.northwestern.at.morphadorner.server.converters.AdornedSentencesConverter;
import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.ListFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@XStreamAlias(value="PartOfSpeechTaggerResult")
public class PartOfSpeechTaggerResult
extends WordTokenizerResult {
    @XStreamConverter(value=AdornedSentencesConverter.class)
    public List<List<AdornedWord>> adornedSentences;
    public boolean outputTEI = false;
    public boolean outputReg = false;
    public boolean outputTCF = false;

    public PartOfSpeechTaggerResult() {
        this.text = "";
        this.corpusConfig = "";
        this.langCode = null;
        this.sentences = null;
        this.adornedSentences = null;
        this.outputTEI = false;
        this.outputReg = false;
        this.outputTCF = false;
    }

    public PartOfSpeechTaggerResult(String text, String corpusConfig, List<List<String>> sentences, List<List<AdornedWord>> adornedSentences, boolean outputTEI, boolean outputReg, boolean outputTCF) {
        this.text = text;
        this.corpusConfig = corpusConfig;
        this.langCode = null;
        this.sentences = sentences;
        this.adornedSentences = adornedSentences;
        this.outputTEI = outputTEI;
        this.outputReg = outputReg;
        this.outputTCF = outputTCF;
    }

    public String toTEIString() {
        StringWriter sw = new StringWriter();
        int wordID = 0;
        sw.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n\r");
        for (int i = 0; i < this.adornedSentences.size(); ++i) {
            sw.write("<s n=\"" + (i + 1) + "\"/>");
            sw.write("\r\n");
            List<AdornedWord> sentence = this.adornedSentences.get(i);
            for (int j = 0; j < sentence.size(); ++j) {
                AdornedWord adornedWord = sentence.get(j);
                String token = adornedWord.getToken();
                sw.write("  <w xml:id=\"w" + ++wordID + "\"");
                sw.write(" lemma=\"" + adornedWord.getLemmata() + "\"");
                sw.write(" ana=\"#" + adornedWord.getPartsOfSpeech() + "\"");
                if (this.outputReg) {
                    sw.write(" reg=\"" + adornedWord.getStandardSpelling() + "\"");
                }
                sw.write(">");
                sw.write(token);
                sw.write("</w>\r\n");
            }
            sw.write("</s>\r\n");
        }
        return sw.toString();
    }

    public DomRepresentation toTEI() {
        DomRepresentation representation = null;
        try {
            representation = new DomRepresentation(MediaType.TEXT_XML);
            Document document = representation.getDocument();
            Element div = document.createElement("div");
            document.appendChild(div);
            int wordID = 0;
            for (int i = 0; i < this.adornedSentences.size(); ++i) {
                Element s = document.createElement("s");
                String nAttributeValue = i + 1 + "";
                s.setAttribute("n", nAttributeValue);
                List<AdornedWord> sentence = this.adornedSentences.get(i);
                MyXMLSentenceMelder melder = new MyXMLSentenceMelder(document, s);
                int l = sentence.size();
                for (int j = 0; j < l; ++j) {
                    Element w;
                    AdornedWord adornedWord = sentence.get(j);
                    String token = adornedWord.getToken();
                    String pos = adornedWord.getPartsOfSpeech();
                    String reg = adornedWord.getStandardSpelling();
                    boolean isPunct = false;
                    if (CharUtils.isPunctuation((String)token)) {
                        w = document.createElement("pc");
                        isPunct = true;
                    } else {
                        w = document.createElement("w");
                        pos = "#" + pos;
                        w.setAttribute("lemma", adornedWord.getLemmata());
                        w.setAttribute("ana", pos);
                        if (this.outputReg) {
                            w.setAttribute("reg", reg);
                        }
                    }
                    w.setTextContent(token);
                    w.setAttribute("xml:id", "w" + ++wordID);
                    if (melder.shouldOutputBlank(token, j == 0)) {
                        melder.outputBlank();
                    }
                    s.appendChild(w);
                    if (j < l - 1 || isPunct) continue;
                    Element pc = document.createElement("pc");
                    pc.setAttribute("xml:id", "w" + wordID + "-1");
                    pc.setAttribute("unit", "sentence");
                    s.appendChild(pc);
                }
                div.appendChild(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return representation;
    }

    @Override
    public String toString() {
        return this.stringFromHTML();
    }

    @Override
    public String toHTML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<h3>\n");
        int nWords = 0;
        for (int i = 0; i < this.adornedSentences.size(); ++i) {
            nWords += this.adornedSentences.get(i).size();
        }
        int nSent = this.adornedSentences.size();
        switch (nSent) {
            case 0: {
                sb.append("No words found.\n");
                break;
            }
            case 1: {
                if (nWords == 1) {
                    sb.append("1 word in 1 sentence.\n");
                    break;
                }
                sb.append(Formatters.formatIntegerWithCommas((int)nWords) + " words in 1 sentence.\n");
                break;
            }
            default: {
                sb.append(Formatters.formatIntegerWithCommas((int)nWords) + " words in " + Formatters.formatIntegerWithCommas((int)nSent) + " sentences found.\n");
            }
        }
        sb.append("</h3>\n");
        sb.append("<table border=\"0\">\n");
        sb.append("<tr>\n");
        sb.append("<th align=\"left\">S#</th><th align=\"left\">W#</th>");
        sb.append("<th align=\"left\">Spelling</th><th align=\"left\">Pos</th>");
        sb.append("<th align=\"left\">Standard</th><th align=\"left\">Lemma</th>");
        sb.append("</tr>\n");
        for (int i = 0; i < nSent; ++i) {
            List<AdornedWord> sentence = this.adornedSentences.get(i);
            for (int j = 0; j < sentence.size(); ++j) {
                AdornedWord adornedWord = sentence.get(j);
                String token = adornedWord.getToken();
                String pos = adornedWord.getPartsOfSpeech();
                String reg = adornedWord.getStandardSpelling();
                String lemma = adornedWord.getLemmata();
                sb.append("<tr><td>");
                sb.append(i + 1 + "");
                sb.append("</td><td>");
                sb.append(j + 1 + "");
                sb.append("</td><td>");
                sb.append(token);
                sb.append("</td><td>");
                sb.append(pos);
                sb.append("</td><td>");
                sb.append(reg);
                sb.append("</td><td>");
                sb.append(lemma);
                sb.append("</td></tr>\n");
            }
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    public Representation toTCF() throws TextCorpusFormatException, UnsupportedEncodingException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        TextCorpusLayerTag[] layersToWrite = new TextCorpusLayerTag[]{TextCorpusLayerTag.TEXT, TextCorpusLayerTag.TOKENS, TextCorpusLayerTag.LEMMAS, TextCorpusLayerTag.POSTAGS, TextCorpusLayerTag.SENTENCES};
        TextCorpusData tc = new TextCorpusData((OutputStream)fos, layersToWrite, "en");
        List tokens = ListFactory.createNewList();
        List lemmata = ListFactory.createNewList();
        List posTags = ListFactory.createNewList();
        List tcfSentences = ListFactory.createNewList();
        TextCorpusFactory tcf = tc.getFactory();
        for (int i = 0; i < this.adornedSentences.size(); ++i) {
            List<AdornedWord> sentence = this.adornedSentences.get(i);
            List tokenRefs = ListFactory.createNewList();
            for (int j = 0; j < sentence.size(); ++j) {
                AdornedWord word = sentence.get(j);
                Token token = tcf.createToken(word.getSpelling());
                tokens.add(token);
                tokenRefs.add(token.getID());
                Tag tag = tcf.createTag(word.getPartsOfSpeech(), new String[]{token.getID()});
                posTags.add(tag);
                Lemma lemma = tcf.createLemma(word.getLemmata(), new String[]{token.getID()});
                lemmata.add(lemma);
            }
            Sentence tcfSentence = tcf.createSentence(tokenRefs);
            tcfSentences.add(tcfSentence);
        }
        tc.writeTextLayer(this.text);
        tc.writeTokensLayer(tokens);
        tc.writePOSTagsLayer(posTags, "NUPOS");
        tc.writeLemmasLayer(lemmata);
        tc.writeSentencesLayer(tcfSentences);
        return new StringRepresentation((CharSequence)new String(fos.toByteArray(), "UTF-8"), MediaType.APPLICATION_XML);
    }
}

