/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.morphadorner.corpuslinguistics.adornedword.BaseAdornedWord;
import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerInfo;
import edu.northwestern.at.morphadorner.server.PartOfSpeechTaggerResult;
import edu.northwestern.at.utils.StringUtils;
import java.util.List;
import org.restlet.data.Form;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class PartOfSpeechTaggerResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("Part of speech tagger resource");
        this.setDescription("Tags words with their parts of speech.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        PartOfSpeechTaggerResult result = this.adornWithPartsOfSpeech(queryParams);
        if (result.outputTEI) {
            return result.toTEI();
        }
        if (result.outputTCF) {
            try {
                return result.toTCF();
            }
            catch (Exception e) {
                return new StringRepresentation((CharSequence)"Unable to generate TCF formatted output.");
            }
        }
        return this.postResults(queryParams, this.adornWithPartsOfSpeech(queryParams), "adornedWord", BaseAdornedWord.class, "token", String.class);
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        PartOfSpeechTaggerResult result = this.adornWithPartsOfSpeech(queryParams);
        if (result.outputTEI) {
            return result.toTEI();
        }
        if (result.outputTCF) {
            try {
                return result.toTCF();
            }
            catch (Exception e) {
                return new StringRepresentation((CharSequence)"Unable to generate TCF formatted output.");
            }
        }
        return this.postResults(queryParams, this.adornWithPartsOfSpeech(queryParams), "adornedWord", BaseAdornedWord.class, "token", String.class);
    }

    public PartOfSpeechTaggerResult adornWithPartsOfSpeech(Form queryParams) {
        boolean outputReg;
        String text = StringUtils.safeString((String)queryParams.getFirstValue("text")).trim();
        text = this.unTag(text);
        boolean includeInputText = queryParams.getFirstValue("includeInputText") != null;
        String corpusConfig = StringUtils.safeString((String)queryParams.getFirstValue("corpusConfig")).trim();
        MorphAdornerServerInfo adornerInfo = MorphAdornerServerData.getAdornerInfo(corpusConfig);
        List sentences = null;
        List adornedSentences = null;
        String xmlOutputType = queryParams.getFirstValue("xmlOutputType");
        if (xmlOutputType == null) {
            xmlOutputType = "outputPlainXML";
        }
        boolean outputTEI = xmlOutputType.equals("outputTEI");
        boolean outputTCF = xmlOutputType.equals("outputTCF");
        boolean bl = outputReg = queryParams.getFirstValue("outputReg") != null;
        if (text.length() > 0) {
            sentences = adornerInfo.sentenceSplitter.extractSentences(text);
            adornedSentences = adornerInfo.adorner.tagger.tagSentences(sentences);
            for (int i = 0; i < adornedSentences.size(); ++i) {
                List sentence = (List)adornedSentences.get(i);
                for (int j = 0; j < sentence.size(); ++j) {
                    AdornedWord wordAndTag = (AdornedWord)sentence.get(j);
                    String standardSpelling = adornerInfo.adorner.spellingStandardizer.standardizeSpelling(wordAndTag.getSpelling(), wordAndTag.getPartsOfSpeech());
                    wordAndTag.setStandardSpelling(standardSpelling);
                    String lemma = adornerInfo.adorner.wordLexicon.getLemma(wordAndTag.getSpelling(), wordAndTag.getPartsOfSpeech());
                    if (lemma.equals("*") && MorphAdornerServerData.lemmatizer != null) {
                        lemma = standardSpelling.length() > 0 ? MorphAdornerServerData.lemmatizer.lemmatize(standardSpelling, adornerInfo.adorner.partOfSpeechTags.getLemmaWordClass(wordAndTag.getPartsOfSpeech())) : MorphAdornerServerData.lemmatizer.lemmatize(wordAndTag.getSpelling(), adornerInfo.adorner.partOfSpeechTags.getLemmaWordClass(wordAndTag.getPartsOfSpeech()));
                    }
                    wordAndTag.setLemmata(lemma);
                }
            }
        }
        return new PartOfSpeechTaggerResult(includeInputText ? text : null, corpusConfig, sentences, adornedSentences, outputTEI, outputReg, outputTCF);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        List<ParameterInfo> params = super.describeParameters();
        ParameterInfo param = new ParameterInfo("text", true, WADLSTRING, ParameterStyle.QUERY, "Text to adorn.");
        params.add(param);
        param = new ParameterInfo("includeInputText", true, WADLBOOLEAN, ParameterStyle.QUERY, "Include input text in output.");
        params.add(param);
        param = new ParameterInfo("corpusConfig", true, WADLSTRING, ParameterStyle.QUERY, "Corpus configuration.");
        params.add(param);
        param = new ParameterInfo("xmlOutputType", true, WADLSTRING, ParameterStyle.QUERY, "Type of XML format for output.");
        params.add(param);
        param = new ParameterInfo("outputReg", true, WADLBOOLEAN, ParameterStyle.QUERY, "Output standardized spelling in TEI XML format.");
        params.add(param);
        return this.sortParams(params);
    }
}

