/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.ParserResult;
import edu.northwestern.at.utils.StringUtils;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jlinkgrammar.Linkage;
import net.sf.jlinkgrammar.Sentence;
import org.restlet.data.Form;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class ParserResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("Parser resource");
        this.setDescription("Parses English text using link grammer parser.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        return this.postResults(queryParams, this.parseText(queryParams));
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        return this.postResults(queryParams, this.parseText(queryParams));
    }

    public ParserResult parseText(Form queryParams) {
        String text = StringUtils.safeString((String)queryParams.getFirstValue("text")).trim();
        text = this.unTag(text);
        boolean includeInputText = queryParams.getFirstValue("includeInputText") != null;
        String parsedText = "No text to parse.";
        if (text.length() > 0) {
            Sentence sentence = this.parse(text);
            if (sentence.sentence_num_linkages_found() < 1) {
                parsedText = "No linkage was found.";
            } else {
                Linkage link = this.getLinkage(sentence, 0);
                parsedText = link.linkage_print_diagram() + "\n";
                parsedText = parsedText + ParserResource.fixOutput(link.linkage_print_links_and_domains());
            }
        }
        return new ParserResult(includeInputText ? text : null, parsedText);
    }

    public Linkage getLinkage(Sentence sentence, int index) {
        return new Linkage(index, sentence, MorphAdornerServerData.parseOptions);
    }

    public Sentence parse(String s) {
        Sentence sentence = new Sentence(s, MorphAdornerServerData.dictionary, MorphAdornerServerData.parseOptions);
        sentence.sentence_parse(MorphAdornerServerData.parseOptions);
        return sentence;
    }

    protected static String fixOutput(String s) {
        String token;
        int j;
        StringTokenizer tokenizer;
        String line;
        int i;
        int[] colWidths = new int[6];
        for (int i2 = 0; i2 < colWidths.length; ++i2) {
            colWidths[i2] = 0;
        }
        String[] lines = s.split("\n");
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < lines.length; ++i) {
            line = lines[i];
            if (line.equals("\n")) continue;
            tokenizer = new StringTokenizer(line);
            j = 0;
            if (line.charAt(0) == ' ') {
                ++j;
            }
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken().trim();
                colWidths[j] = Math.max(colWidths[j], token.length());
                ++j;
            }
        }
        i = 0;
        while (i < colWidths.length) {
            int n = i++;
            colWidths[n] = colWidths[n] + 2;
        }
        for (i = 0; i < lines.length; ++i) {
            line = lines[i];
            if (line.equals("\n")) continue;
            tokenizer = new StringTokenizer(line);
            j = 0;
            if (line.charAt(0) == ' ') {
                sb.append(StringUtils.dupl((String)" ", (int)colWidths[j++]));
            }
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                sb.append(StringUtils.rpad((String)token, (int)colWidths[j++]));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        List<ParameterInfo> params = super.describeParameters();
        ParameterInfo param = new ParameterInfo("text", true, WADLSTRING, ParameterStyle.QUERY, "Text to parse.");
        params.add(param);
        param = new ParameterInfo("includeInputText", true, WADLBOOLEAN, ParameterStyle.QUERY, "Include input text in output.");
        params.add(param);
        return this.sortParams(params);
    }
}

