/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import edu.northwestern.at.morphadorner.server.BaseResults;
import edu.northwestern.at.morphadorner.server.converters.PersonNamesSetConverter;
import edu.northwestern.at.morphadorner.server.converters.PlaceNamesSetConverter;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.ListFactory;
import java.util.List;
import java.util.Set;

@XStreamAlias(value="NameRecognizerResult")
public class NameRecognizerResult
extends BaseResults {
    public String text;
    public String corpusConfig;
    @XStreamConverter(value=PersonNamesSetConverter.class)
    public Set<String> personNames;
    @XStreamConverter(value=PlaceNamesSetConverter.class)
    public Set<String> placeNames;

    public NameRecognizerResult() {
        this.text = "";
        this.corpusConfig = "";
        this.personNames = null;
        this.placeNames = null;
    }

    public NameRecognizerResult(String text, String corpusConfig, Set<String> personNames, Set<String> placeNames) {
        this.text = text;
        this.corpusConfig = corpusConfig;
        this.personNames = personNames;
        this.placeNames = placeNames;
    }

    public String toString() {
        return this.stringFromHTML();
    }

    @Override
    public String toHTML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<h3>\n");
        int nPersonNames = this.personNames.size();
        int nPlaceNames = this.placeNames.size();
        switch (nPersonNames) {
            case 0: {
                sb.append("No person names found.\n");
                break;
            }
            case 1: {
                sb.append("1 person name found.\n");
                break;
            }
            default: {
                sb.append(Formatters.formatIntegerWithCommas((int)nPersonNames) + " person names found.\n");
            }
        }
        sb.append("</h3>\n");
        sb.append("<table border=\"0\">\n");
        List personNamesList = ListFactory.createNewList(this.personNames);
        for (int i = 0; i < personNamesList.size(); ++i) {
            String personName = (String)personNamesList.get(i);
            sb.append("<tr><td>");
            sb.append(personName);
            sb.append("</td></tr>\n");
        }
        sb.append("</table>\n");
        sb.append("<h3>\n");
        switch (nPlaceNames) {
            case 0: {
                sb.append("No place names found.\n");
                break;
            }
            case 1: {
                sb.append("1 place name found.\n");
                break;
            }
            default: {
                sb.append(Formatters.formatIntegerWithCommas((int)nPlaceNames) + " place names found.\n");
            }
        }
        sb.append("</h3>\n");
        sb.append("<table border=\"0\">\n");
        List placeNamesList = ListFactory.createNewList(this.placeNames);
        for (int i = 0; i < placeNamesList.size(); ++i) {
            String placeName = (String)placeNamesList.get(i);
            sb.append("<tr><td>");
            sb.append(placeName);
            sb.append("</td></tr>\n");
        }
        sb.append("</table>\n");
        return sb.toString();
    }
}

