/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerInfo;
import edu.northwestern.at.morphadorner.server.NameRecognizerResult;
import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.StringUtils;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.restlet.data.Form;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class NameRecognizerResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("Name recognizer resource");
        this.setDescription("Recognizes proper names in text.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        return this.postResults(queryParams, this.recognizeNames(queryParams));
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        return this.postResults(queryParams, this.recognizeNames(queryParams));
    }

    public NameRecognizerResult recognizeNames(Form queryParams) {
        String text = StringUtils.safeString((String)queryParams.getFirstValue("text")).trim();
        text = this.unTag(text);
        boolean includeInputText = queryParams.getFirstValue("includeInputText") != null;
        String corpusConfig = StringUtils.safeString((String)queryParams.getFirstValue("corpusConfig")).trim();
        MorphAdornerServerInfo adornerInfo = MorphAdornerServerData.getAdornerInfo(corpusConfig);
        Set[] namesInText = null;
        if (text.length() > 0) {
            namesInText = adornerInfo.nameRecognizer.findNames(text);
        }
        SortedSet sortedNamesSet = SetFactory.createNewSortedSet();
        sortedNamesSet.addAll(namesInText[0]);
        SortedSet sortedPlacesSet = SetFactory.createNewSortedSet();
        sortedPlacesSet.addAll(namesInText[1]);
        return new NameRecognizerResult(includeInputText ? text : null, corpusConfig, sortedNamesSet, sortedPlacesSet);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        List<ParameterInfo> params = super.describeParameters();
        ParameterInfo param = new ParameterInfo("text", true, WADLSTRING, ParameterStyle.QUERY, "Text containing names to recognize.");
        params.add(param);
        param = new ParameterInfo("includeInputText", true, WADLBOOLEAN, ParameterStyle.QUERY, "Include input text in output.");
        params.add(param);
        param = new ParameterInfo("corpusConfig", true, WADLSTRING, ParameterStyle.QUERY, "Corpus configuration.");
        params.add(param);
        return this.sortParams(params);
    }
}

