/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.MorphAdorner;
import edu.northwestern.at.morphadorner.corpuslinguistics.namerecognizer.DefaultNameRecognizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.namerecognizer.NameRecognizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.namestandardizer.DefaultNameStandardizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.namestandardizer.NameStandardizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.sentencesplitter.DefaultSentenceSplitter;
import edu.northwestern.at.morphadorner.corpuslinguistics.sentencesplitter.SentenceSplitter;
import edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer.ExtendedSearchSpellingStandardizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer.ExtendedSimpleSpellingStandardizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.spellingstandardizer.GapFiller;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.logging.MorphAdornerServerLogger;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.KeyedSets;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class MorphAdornerServerInfo {
    public String serverInfoName;
    public String serverInfoDescription;
    public MorphAdorner adorner;
    public GapFiller gapFiller;
    public NameRecognizer nameRecognizer;
    public SentenceSplitter sentenceSplitter;
    public ExtendedSimpleSpellingStandardizer simpleStandardizer;
    public ExtendedSearchSpellingStandardizer standardizer;
    public NameStandardizer nameStandardizer;
    public KeyedSets<String, String> lemmaToSpellings;

    public MorphAdornerServerInfo(String serverInfoName, String serverInfoDescription, String configFileName) throws Exception {
        MorphAdornerServerLogger.logger.log((Priority)Level.INFO, (Object)("Creating MorphAdorner configuration " + serverInfoName + " from " + configFileName));
        this.serverInfoName = serverInfoName;
        this.serverInfoDescription = serverInfoDescription;
        ArrayList<String> morphArgs = new ArrayList<String>();
        String ddir = MorphAdornerServerData.dataDirectory;
        morphArgs.add("-p");
        morphArgs.add(configFileName);
        morphArgs.add("-d");
        morphArgs.add(MorphAdornerServerData.makeFileName(ddir, "morphadorner.properties"));
        String[] morphArgsArray = morphArgs.toArray(new String[morphArgs.size()]);
        String currentDirectory = FileUtils.getCurrentDirectory();
        FileUtils.chdir((String)ddir);
        this.adorner = MorphAdorner.createAdorner((String)serverInfoName, (boolean)false, (String[])morphArgsArray, null, null);
        FileUtils.chdir((String)currentDirectory);
        String[] spellings = this.adorner.wordLexicon.getEntries();
        this.lemmaToSpellings = new KeyedSets();
        for (int i = 0; i < spellings.length; ++i) {
            String spelling = spellings[i];
            String[] lemmata = this.adorner.wordLexicon.getLemmata(spelling);
            for (int j = 0; j < lemmata.length; ++j) {
                this.lemmaToSpellings.add((Comparable)((Object)lemmata[j]), (Object)spelling);
            }
        }
        this.gapFiller = new GapFiller(this.adorner.spellingStandardizer.getMappedSpellings());
        this.gapFiller.addWords((Collection)this.adorner.spellingStandardizer.getStandardSpellings());
        this.gapFiller.addWords(this.adorner.wordLexicon.getEntries());
        this.nameRecognizer = new DefaultNameRecognizer();
        this.nameRecognizer.setPartOfSpeechTagger(this.adorner.tagger);
        this.sentenceSplitter = new DefaultSentenceSplitter();
        this.sentenceSplitter.setPartOfSpeechGuesser(this.adorner.partOfSpeechGuesser);
        this.sentenceSplitter.setAbbreviations(this.adorner.abbreviations);
        this.standardizer = new ExtendedSearchSpellingStandardizer();
        this.standardizer.setStandardSpellings(this.adorner.spellingStandardizer.getStandardSpellings());
        this.standardizer.addStandardSpellings((Collection)MorphAdornerServerData.names.getFirstNames());
        this.standardizer.addStandardSpellings((Collection)MorphAdornerServerData.names.getSurnames());
        this.standardizer.addStandardSpellings(MorphAdornerServerData.names.getPlaceNames().keySet());
        this.standardizer.setMappedSpellings(this.adorner.spellingStandardizer.getMappedSpellings());
        this.standardizer.createDictionaries();
        this.simpleStandardizer = new ExtendedSimpleSpellingStandardizer();
        this.simpleStandardizer.setMappedSpellings(this.adorner.spellingStandardizer.getMappedSpellings());
        this.simpleStandardizer.setStandardSpellings(this.adorner.spellingStandardizer.getStandardSpellings());
        this.standardizer.setGapFiller(this.gapFiller);
        this.simpleStandardizer.setGapFiller(this.gapFiller);
        this.nameStandardizer = new DefaultNameStandardizer();
        this.nameStandardizer.loadNamesFromLexicon(this.adorner.wordLexicon);
        this.nameStandardizer.loadNames((Collection)MorphAdornerServerData.names.getFirstNames());
        this.nameStandardizer.loadNames((Collection)MorphAdornerServerData.names.getSurnames());
        this.nameStandardizer.loadNames(MorphAdornerServerData.names.getPlaceNames().keySet());
    }

    public String toString() {
        return this.serverInfoDescription;
    }
}

