/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.corpuslinguistics.hyphenator.AmericanHyphenator;
import edu.northwestern.at.morphadorner.corpuslinguistics.hyphenator.BritishHyphenator;
import edu.northwestern.at.morphadorner.corpuslinguistics.hyphenator.Hyphenator;
import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.EnglishInflector;
import edu.northwestern.at.morphadorner.corpuslinguistics.inflector.Inflector;
import edu.northwestern.at.morphadorner.corpuslinguistics.languagerecognizer.DefaultLanguageRecognizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.languagerecognizer.LanguageRecognizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.lemmatizer.DefaultLemmatizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.lemmatizer.Lemmatizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.namerecognizer.Names;
import edu.northwestern.at.morphadorner.corpuslinguistics.spellingmapper.BritishToUSSpellingMapper;
import edu.northwestern.at.morphadorner.corpuslinguistics.spellingmapper.SpellingMapper;
import edu.northwestern.at.morphadorner.corpuslinguistics.stemmer.LancasterStemmer;
import edu.northwestern.at.morphadorner.corpuslinguistics.stemmer.PorterStemmer;
import edu.northwestern.at.morphadorner.corpuslinguistics.stemmer.Stemmer;
import edu.northwestern.at.morphadorner.corpuslinguistics.syllablecounter.DefaultSyllableCounter;
import edu.northwestern.at.morphadorner.corpuslinguistics.syllablecounter.SyllableCounter;
import edu.northwestern.at.morphadorner.corpuslinguistics.thesaurus.Thesaurus;
import edu.northwestern.at.morphadorner.corpuslinguistics.thesaurus.WordnetThesaurus;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerInfo;
import edu.northwestern.at.morphadorner.server.logging.MorphAdornerServerLogger;
import edu.northwestern.at.utils.DebugUtils;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.UTF8Properties;
import edu.northwestern.at.utils.UTF8PropertyUtils;
import java.io.File;
import java.util.Map;
import javax.servlet.ServletContext;
import net.sf.jlinkgrammar.Dictionary;
import net.sf.jlinkgrammar.ParseOptions;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class MorphAdornerServerData {
    protected static String serverVersion = "1.0.0";
    protected static String defaultDataDirectory = "data";
    protected static String dataDirectory = null;
    protected static ServletContext context = null;
    protected static int maxUnadornedUploadFileSize = 0x500000;
    protected static int maxAdornedUploadFileSize = 0x3200000;
    protected static Lemmatizer lemmatizer;
    protected static Stemmer porterStemmer;
    protected static Stemmer lancasterStemmer;
    protected static Names names;
    protected static LanguageRecognizer languageRecognizer;
    protected static Inflector inflector;
    protected static SpellingMapper britishToUS;
    protected static Dictionary dictionary;
    protected static ParseOptions parseOptions;
    protected static String lgParserDataDirectory;
    protected static String wordnetDataDirectory;
    protected static Thesaurus thesaurus;
    protected static Hyphenator britishHyphenator;
    protected static Hyphenator americanHyphenator;
    protected static SyllableCounter syllableCounter;
    protected static Map<String, MorphAdornerServerInfo> corpusConfigs;
    protected static MorphAdornerServerInfo refAdornerInfo;
    protected static final int INITNOTSTARTED = 0;
    protected static final int INITINPROGRESS = 1;
    protected static final int INITDONE = 2;
    protected static final int INITFAILED = 3;
    protected static int initializationStatus;
    protected static final String servletNotReadyMessage = "MorphAdorner server not yet ready, please try again in a minute.";
    protected static final String servletNotReadyTitle = "MorphAdorner server not ready";

    public static synchronized void initialize() {
        if (initializationStatus != 0) {
            return;
        }
        try {
            initializationStatus = 1;
            MorphAdornerServerLogger.logger.log((Priority)Level.INFO, (Object)"MorphAdorner server initialization started.");
            dataDirectory = new File(dataDirectory).getCanonicalPath();
            MorphAdornerServerLogger.logger.log((Priority)Level.INFO, (Object)("MorphAdorner Server data directory is " + dataDirectory));
            MorphAdornerServerLogger.logger.log((Priority)Level.INFO, (Object)("Maximum unadorned file size upload is " + Formatters.formatIntegerWithCommas((int)maxUnadornedUploadFileSize)));
            MorphAdornerServerLogger.logger.log((Priority)Level.INFO, (Object)("Maximum adorned file size upload is " + Formatters.formatIntegerWithCommas((int)maxAdornedUploadFileSize)));
            lgParserDataDirectory = MorphAdornerServerData.makeFileName(dataDirectory, lgParserDataDirectory);
            wordnetDataDirectory = MorphAdornerServerData.makeFileName(dataDirectory, wordnetDataDirectory);
            languageRecognizer = new DefaultLanguageRecognizer();
            File fDataDir = new File(dataDirectory);
            File[] filesAndDirs = fDataDir.listFiles();
            for (int i = 0; i < filesAndDirs.length; ++i) {
                String fileName;
                String extension;
                File file = filesAndDirs[i];
                if (!file.isFile() || !(extension = FileNameUtils.getFileExtension((String)(fileName = file.getAbsolutePath()), (boolean)false)).equalsIgnoreCase("properties")) continue;
                UTF8Properties corpusProperties = UTF8PropertyUtils.loadUTF8Properties((String)fileName);
                String configName = corpusProperties.getProperty("corpus.name", "").trim();
                String configDescription = corpusProperties.getProperty("corpus.description", "").trim();
                if (configName.length() <= 0 || configDescription.length() <= 0) continue;
                MorphAdornerServerInfo adornerInfo = new MorphAdornerServerInfo(configName, configDescription, fileName);
                corpusConfigs.put(configName, adornerInfo);
                if (refAdornerInfo != null) continue;
                refAdornerInfo = adornerInfo;
            }
            if (corpusConfigs.size() == 0) {
                MorphAdornerServerLogger.logger.log((Priority)Level.ERROR, (Object)"No corpus configurations found.");
                initializationStatus = 3;
            }
            if (lemmatizer == null) {
                lemmatizer = new DefaultLemmatizer();
                if (refAdornerInfo != null) {
                    lemmatizer.setDictionary(MorphAdornerServerData.refAdornerInfo.adorner.spellingStandardizer.getStandardSpellings());
                }
            }
            if (parseOptions == null) {
                parseOptions = new ParseOptions();
                parseOptions.parse_options_set_short_length(10);
                parseOptions.parse_options_set_max_null_count(10);
                parseOptions.parse_options_set_linkage_limit(100);
            }
            if (dictionary == null) {
                dictionary = new Dictionary(parseOptions, lgParserDataDirectory + "/4.0.dict", "4.0.knowledge", "4.0.constituent-knowledge", "4.0.affix");
            }
            try {
                thesaurus = new WordnetThesaurus(wordnetDataDirectory);
            }
            catch (Exception e) {
                MorphAdornerServerLogger.logger.log((Priority)Level.ERROR, (Object)DebugUtils.getStackTrace((Throwable)e));
                initializationStatus = 3;
            }
            if (initializationStatus != 3) {
                initializationStatus = 2;
                MorphAdornerServerLogger.logger.log((Priority)Level.INFO, (Object)"MorphAdorner server initialization finished.");
            }
        }
        catch (Exception e) {
            MorphAdornerServerLogger.logger.log((Priority)Level.ERROR, (Object)DebugUtils.getStackTrace((Throwable)e));
            initializationStatus = 3;
        }
        if (initializationStatus == 3) {
            MorphAdornerServerLogger.logger.log((Priority)Level.ERROR, (Object)"MorphAdorner server initialization failed.");
        }
    }

    public static synchronized String makeFileName(String directoryName, String fileName) throws SecurityException {
        return new File(directoryName, fileName).getAbsolutePath();
    }

    public static synchronized String makeFileName(File directory, String fileName) throws SecurityException {
        return new File(directory, fileName).getAbsolutePath();
    }

    public static MorphAdornerServerInfo getAdornerInfo(String adornerName) {
        return corpusConfigs.get(adornerName);
    }

    public static boolean isReady() {
        return initializationStatus == 2;
    }

    public static int getIntValue(String requestValue, int defaultValue) {
        int result = defaultValue;
        if (requestValue != null) {
            try {
                result = Integer.parseInt(requestValue);
            }
            catch (NumberFormatException e) {
                result = defaultValue;
            }
        }
        return result;
    }

    public static String getMorphAdornerVersion() {
        String result = "Not available";
        if (refAdornerInfo != null && MorphAdornerServerData.refAdornerInfo.adorner != null) {
            result = MorphAdornerServerData.refAdornerInfo.adorner.morphAdornerSettings.getMorphAdornerVersion();
        }
        return result;
    }

    public static String getServerVersion() {
        return serverVersion;
    }

    public static String getDataDirectory() {
        return dataDirectory;
    }

    public static void setDataDirectory(String dataDir) {
        dataDirectory = dataDir;
    }

    public static int convertStringFileSize(String sFileSize) {
        int fileSize = -1;
        if (sFileSize != null) {
            int multiplier = 1;
            String fileSizeString = sFileSize.toLowerCase();
            if (fileSizeString.endsWith("g")) {
                multiplier = 0x40000000;
                fileSizeString = fileSizeString.substring(0, fileSizeString.length() - 1);
            } else if (fileSizeString.endsWith("m")) {
                multiplier = 0x100000;
                fileSizeString = fileSizeString.substring(0, fileSizeString.length() - 1);
            } else if (fileSizeString.endsWith("k")) {
                multiplier = 1024;
                fileSizeString = fileSizeString.substring(0, fileSizeString.length() - 1);
            }
            try {
                fileSize = Integer.parseInt(fileSizeString) * multiplier;
            }
            catch (Exception e) {
                fileSize = -1;
            }
        }
        return fileSize;
    }

    public static void setMaxUnadornedUploadFileSize(String maxFileSize) {
        int fileSize = MorphAdornerServerData.convertStringFileSize(maxFileSize);
        if (fileSize >= 0) {
            maxUnadornedUploadFileSize = fileSize;
        }
    }

    public static int getMaxUnadornedUploadFileSize() {
        return maxUnadornedUploadFileSize;
    }

    public static void setMaxAdornedUploadFileSize(String maxFileSize) {
        int fileSize = MorphAdornerServerData.convertStringFileSize(maxFileSize);
        if (fileSize >= 0) {
            maxAdornedUploadFileSize = fileSize;
        }
    }

    public static int getMaxAdornedUploadFileSize() {
        return maxAdornedUploadFileSize;
    }

    public static ServletContext getContext() {
        return context;
    }

    public static void setContext(ServletContext theContext) {
        context = theContext;
    }

    static {
        porterStemmer = new PorterStemmer();
        lancasterStemmer = new LancasterStemmer();
        names = new Names();
        languageRecognizer = null;
        inflector = new EnglishInflector();
        britishToUS = new BritishToUSSpellingMapper();
        lgParserDataDirectory = "lgparser";
        wordnetDataDirectory = "wordnet/3.0/dict";
        britishHyphenator = new BritishHyphenator();
        americanHyphenator = new AmericanHyphenator();
        syllableCounter = new DefaultSyllableCounter();
        corpusConfigs = MapFactory.createNewSortedMap();
        refAdornerInfo = null;
        initializationStatus = 0;
    }
}

