/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.CorpusConfigResource;
import edu.northwestern.at.morphadorner.server.GapFillerResource;
import edu.northwestern.at.morphadorner.server.HyphenatorResource;
import edu.northwestern.at.morphadorner.server.LanguageRecogniserResource;
import edu.northwestern.at.morphadorner.server.LanguageRecognizerResource;
import edu.northwestern.at.morphadorner.server.LemmatiserResource;
import edu.northwestern.at.morphadorner.server.LemmatizerResource;
import edu.northwestern.at.morphadorner.server.LexiconLookupResource;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.NameRecognizerResource;
import edu.northwestern.at.morphadorner.server.ParserResource;
import edu.northwestern.at.morphadorner.server.PartOfSpeechTaggerResource;
import edu.northwestern.at.morphadorner.server.PluralizerResource;
import edu.northwestern.at.morphadorner.server.SentenceSplitterResource;
import edu.northwestern.at.morphadorner.server.SpellingStandardizerResource;
import edu.northwestern.at.morphadorner.server.SummarizerResource;
import edu.northwestern.at.morphadorner.server.SyllableCounterResource;
import edu.northwestern.at.morphadorner.server.TEIAdornedToSentencesResource;
import edu.northwestern.at.morphadorner.server.TEIAdornedToTabularFileResource;
import edu.northwestern.at.morphadorner.server.TEIAdornerResource;
import edu.northwestern.at.morphadorner.server.TEIApplyChangesToAdornedFileResource;
import edu.northwestern.at.morphadorner.server.TEICompareAdornedFilesResource;
import edu.northwestern.at.morphadorner.server.TEINotesMoverResource;
import edu.northwestern.at.morphadorner.server.TEIToTextResource;
import edu.northwestern.at.morphadorner.server.TEITokenizerResource;
import edu.northwestern.at.morphadorner.server.TEIUnadornerResource;
import edu.northwestern.at.morphadorner.server.TextSegmenterResource;
import edu.northwestern.at.morphadorner.server.ThesaurusResource;
import edu.northwestern.at.morphadorner.server.VerbConjugatorResource;
import edu.northwestern.at.morphadorner.server.VersionResource;
import edu.northwestern.at.morphadorner.server.WADLConverter;
import edu.northwestern.at.morphadorner.server.WordTokenizerResource;
import edu.northwestern.at.utils.FileUtils;
import java.io.File;
import javax.servlet.ServletContext;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.ext.wadl.ApplicationInfo;
import org.restlet.ext.wadl.WadlApplication;
import org.restlet.representation.Representation;
import org.restlet.resource.Directory;
import org.restlet.routing.Router;

public class MorphAdornerServerApplication
extends WadlApplication {
    public MorphAdornerServerApplication() {
        this.setName("MorphAdorner Services Server Application");
        this.setDescription("MorphAdorner web services");
        this.setOwner("Northwestern University");
        this.setAuthor("Philip R. Burns");
        this.getMetadataService().addExtension("multipart", (Metadata)MediaType.MULTIPART_FORM_DATA, true);
    }

    public synchronized Restlet createInboundRoot() {
        MorphAdornerServerData.initialize();
        Router router = new Router(this.getContext());
        Directory staticPagesDirectory = new Directory(this.getContext(), this.getRootURI(this.getContext()));
        staticPagesDirectory.setListingAllowed(true);
        staticPagesDirectory.setModifiable(false);
        router.attachDefault((Restlet)staticPagesDirectory);
        router.attach("/corpusconfig", CorpusConfigResource.class);
        router.attach("/gapfiller", GapFillerResource.class);
        router.attach("/hyphenator", HyphenatorResource.class);
        router.attach("/languagerecognizer", LanguageRecognizerResource.class);
        router.attach("/languagerecogniser", LanguageRecogniserResource.class);
        router.attach("/lemmatizer", LemmatizerResource.class);
        router.attach("/lemmatiser", LemmatiserResource.class);
        router.attach("/lexiconlookup", LexiconLookupResource.class);
        router.attach("/namerecognizer", NameRecognizerResource.class);
        router.attach("/namerecogniser", NameRecognizerResource.class);
        router.attach("/parser", ParserResource.class);
        router.attach("/partofspeechtagger", PartOfSpeechTaggerResource.class);
        router.attach("/pluralizer", PluralizerResource.class);
        router.attach("/pluraliser", PluralizerResource.class);
        router.attach("/sentencesplitter", SentenceSplitterResource.class);
        router.attach("/spellingstandardizer", SpellingStandardizerResource.class);
        router.attach("/spellingstandardiser", SpellingStandardizerResource.class);
        router.attach("/summarizer", SummarizerResource.class);
        router.attach("/summariser", SummarizerResource.class);
        router.attach("/syllablecounter", SyllableCounterResource.class);
        router.attach("/teiadornedtosentences", TEIAdornedToSentencesResource.class);
        router.attach("/teiadornedtotabularformat", TEIAdornedToTabularFileResource.class);
        router.attach("/teiapplychangestoadornedfile", TEIApplyChangesToAdornedFileResource.class);
        router.attach("/teicompareadornedfiles", TEICompareAdornedFilesResource.class);
        router.attach("/teitotext", TEIToTextResource.class);
        router.attach("/teiadorner", TEIAdornerResource.class);
        router.attach("/teinotesmover", TEINotesMoverResource.class);
        router.attach("/teitokenizer", TEITokenizerResource.class);
        router.attach("/teitokeniser", TEITokenizerResource.class);
        router.attach("/teiunadorner", TEIUnadornerResource.class);
        router.attach("/textsegmenter", TextSegmenterResource.class);
        router.attach("/thesaurus", ThesaurusResource.class);
        router.attach("/verbconjugator", VerbConjugatorResource.class);
        router.attach("/version", VersionResource.class);
        router.attach("/wordtokenizer", WordTokenizerResource.class);
        router.attach("/wordtokeniser", WordTokenizerResource.class);
        return router;
    }

    protected String getRootURI(Context context) {
        ServletContext servletContext = (ServletContext)this.getContext().getAttributes().get("org.restlet.ext.servlet.ServletContext");
        String rootURI = "";
        if (servletContext == null) {
            rootURI = new File(FileUtils.getCurrentDirectory(), "webpages").getAbsolutePath();
            rootURI = "file:///" + rootURI + File.separator;
        } else {
            String path = servletContext.getRealPath(".");
            int last = path.lastIndexOf(".");
            rootURI = "file:///" + path.substring(0, last).replace('\\', '/');
        }
        return rootURI;
    }

    protected Representation createHtmlRepresentation(ApplicationInfo applicationInfo) {
        Representation result = null;
        try {
            result = WADLConverter.createHtmlRepresentation(this.createWadlRepresentation(applicationInfo).getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

