/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.MorphAdornerServerApplication;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.logging.MorphAdornerServerLogger;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Protocol;

public class MorphAdornerServer {
    public static final int DEFAULT_SERVER_PORT = 8182;

    public static void main(String[] args) {
        int serverPort = 8182;
        if (args.length > 0) {
            try {
                serverPort = Integer.parseInt(args[0]);
            }
            catch (Exception e) {
                MorphAdornerServerLogger.logger.trace((Object)e);
                serverPort = 8182;
            }
        }
        if (args.length > 1) {
            try {
                MorphAdornerServerData.setDataDirectory(args[1]);
            }
            catch (Exception e) {
                MorphAdornerServerLogger.logger.trace((Object)e);
                MorphAdornerServerData.setDataDirectory(null);
            }
        }
        try {
            Component component = new Component();
            Server server = new Server(Protocol.HTTP, serverPort);
            component.getServers().add(server);
            server.getContext().getParameters().add("maxThreads", "1024");
            component.getClients().add(Protocol.FILE);
            component.getDefaultHost().attach((Restlet)new MorphAdornerServerApplication());
            component.start();
        }
        catch (Exception e) {
            MorphAdornerServerLogger.logger.trace((Object)e);
        }
    }
}

